/*
 * trx.h - TRX - receives and transmits packets
 *
 * Written by Michael "Mr. Sump." Poppitz
 *
 */

 /***************************************************************************
  *                                                                         *
  *   This program is free software; you can redistribute it and/or modify  *
  *   it under the terms of the GNU General Public License as published by  *
  *   the Free Software Foundation; either version 2 of the License, or     *
  *   (at your option) any later version.                                   *
  *                                                                         *
  ***************************************************************************/

#ifndef TRX_H
#define TRX_H

#include <features.h>
#if __GLIBC__ > 2 || (__GLIBC == 2 && __GLIBC_MINOR >= 1)
#include <netpacket/packet.h>
#include <net/ethernet.h>
#else
#include <asm/types.h>
#include <linux/if_packet.h>
#include <linux/if_ether.h>
#endif

#include "packet.h"

class TRX {
	public:
		TRX();
		TRX(char *device);
		~TRX();
		
		int init();
		Packet *rx();
		int tx(Packet *pa);
		int tx(char *device, Packet *pa);

		const static int ERROR = -1;

	private:
		int getInterfaceIndex(char *device);
		void getInterfaceName(char *buffer, int ifindex);

		int sock;
		struct sockaddr_ll sa;
		size_t sas;
};

#endif
