/*
 * s2attractor.cpp - Silencer Toolkit Example Application
 *
 * Written by Michael "Mr. Sump" Poppitz.
 *
 */

 /***************************************************************************
  *                                                                         *
  *   This program is free software; you can redistribute it and/or modify  *
  *   it under the terms of the GNU General Public License as published by  *
  *   the Free Software Foundation; either version 2 of the License, or     *
  *   (at your option) any later version.                                   *
  *                                                                         *
  ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "trx.h"
#include "packet.h"
#include "factory.h"
#include "monitor.h"

bool check(Packet *pa) {				/* does the testing for our criteria */
	char used[7];

	if (pa->getFrameType() != pa->FRAME_U)
		return (false);

	if (pa->getUFrameType() != pa->UFRAME_UA)
		return (false);
	
	return (true);					/* if we got this far, */
							/* it must be the proper type */
}

void announce(TRX *trx, char *dev) {			/* give the desired response */
	PacketFactory *pf = new PacketFactory(dev);	/* create factory on device*/
	Call *s = new Call("TE0ST");
	Call *d = new Call("ALL");
	Packet *p = pf->produceBeacon(s, d, "hello");	/* produce beacon */
	delete d;
	delete s;
	trx->tx(p);					/* transmit beacon */
	delete p;
	delete pf;					/* free up resources */
}

int main() {
	TRX *trx = new TRX();				/* get an trx, so we can listen for packets */
	Monitor *mon = new Monitor();			/* get monitor for outputting traffic */

	if (trx->init() < 0) {
		perror("init"); 
		exit(EXIT_FAILURE);
	}						/* something went wrong, abort */

	while (Packet *pa = trx->rx()) {		/* keep listening until error occurs */
		mon->display(pa);			/* display packet */
		if (check(pa)) {			/* check if some could have connected somewhere */
			char dev[32];
			pa->getDevice(dev);
			announce(trx, dev);		/* if so, announce that we are here :) */
			puts("==> Announced!");		/* tell user what we just did */
		}
		delete pa;				/* destroy packet */
	}

	return(EXIT_SUCCESS);
}
