/*
 * packet.h - Packet - this is what it all comes down to :)
 *
 * Written by Michael "Mr. Sump" Poppitz.
 *
 */
 
#ifndef PACKET_H
#define PACKET_H

#include <stdlib.h>
#include <string.h>

#include "call.h"

class Packet {
	public:
		const static int DATA_LIMIT = 0x200;
		const static int REPEATER_LIMIT = 8;

		Packet();
		Packet(void *packet, int len);
		~Packet();

		void setDevice(char *device);
		void getDevice(char *buffer);

		int setData(void *src, int len);
		int getData(void *dest);
		void *getDataPointer(void);
		void setDataLength(int len);
		int getDataLength(void);
		int getLength(void);

		Call *getSourceCall(void);
		Call *getDestinationCall(void);
		Call *getRepeaterCall(int nr);
		bool hasBeenRepeated(int nr);		
		int getRepeaterCount();

		int getFrameType();
		const static int FRAME_I = 0;
		const static int FRAME_S = 1;
		const static int FRAME_U = 3;

		int getInfoLength();
		const static int IFRAME_DUMMY = 0;

		int getSFrameType();
		const static int SFRAME_RR  = 0;
		const static int SFRAME_RNR = 1;
		const static int SFRAME_REJ = 2;

		int getUFrameType();
		const static int UFRAME_UI = 0;
		const static int UFRAME_DM = 3;
		const static int UFRAME_SABM = 7;
		const static int UFRAME_DISC = 8;
		const static int UFRAME_UA = 12;
		const static int UFRAME_FRMR = 17;

		int getReceiveSequence();
		int getSendSequence();
		int getPID();

		bool hasInfo();
		int getInfo(unsigned char *buffer);

		void reverseCalls(void);
		void setSourceCall(Call *call);
		void setDestinationCall(Call *call);
		void setRepeaterCall(int nr, Call *call);
		bool setRepeaterCount(int num);

		void setCommand();
		void setResponse();
		void disableCR();

		bool setFrameType(int type, int subtype);
		bool setReceiveSequence(int seq);
		bool setSendSequence(int seq);
		bool setInfo(unsigned char *buff, int len);

		const static int ERROR = -1;

	private:
		int decodeCall(char *decall, unsigned char *encall);
		void encodeCall(unsigned char *encall, char *decall, int ssid);
		unsigned char getControlByte();
		int getBaseLength();
		bool isValidRepeaterNr(int nr);
				
		char dev[32];
		unsigned char *raw;
		unsigned char *data;
		int length;
};

#endif
	                		