/*
 * monitor.cpp - Monitor - monitors traffic
 *
 * Written by Michael "Mr. Sump" Poppitz.
 *
 */

 /***************************************************************************
  *                                                                         *
  *   This program is free software; you can redistribute it and/or modify  *
  *   it under the terms of the GNU General Public License as published by  *
  *   the Free Software Foundation; either version 2 of the License, or     *
  *   (at your option) any later version.                                   *
  *                                                                         *
  ***************************************************************************/



#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <linux/if.h>
#include <linux/if_ether.h>

#include "monitor.h"

Monitor::Monitor() {
	unsigned char tmp[] = {
		'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '\n', '.', '.', '\n', '.', '.',
		'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.',
		' ', '!', '"', '#', '$', '%', '&',  44, '(', ')', '*', '+',  44, '-', '.', '/',
		'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?',
		'@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
		'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[',  92, ']', '^', '_',
		'.', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',
		'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.',
		'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.',
		'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.',
		'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.',
		'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.',
		'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.',
		'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.',
		'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.',
		'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'
	};
	// this may look a lil odd - but its all about flexibility :) 
	memcpy((void *)raw2disp, (void *)tmp, 0x100);
}

Monitor::~Monitor() {
}

void Monitor::displayText(Packet *pa) {
	unsigned char tmp[0x100];

	tmp[pa->getInfo(tmp)] = 0;
	for (int i = 0; i < 0x100 && tmp[i] != 0; i++)
		tmp[i] = raw2disp[tmp[i]];
	printf("%s", tmp);
}

void Monitor::display(Packet *pa) {
	char dev[32];
	pa->getDevice(dev);
	Call *dest = pa->getDestinationCall();
	Call *src = pa->getSourceCall();

	int cnt = pa->getRepeaterCount();

	printf("%s: %s.%1x > %s.%1x", dev, src->call, src->ssid, dest->call, dest->ssid);

	delete src;
	delete dest;

	if (cnt > 0) {
		printf(" v");
		for (int i = 0; i < cnt; i++) {
			Call *node = pa->getRepeaterCall(i);
			printf(" %s|%1x", node->call, node->ssid);
			if (pa->hasBeenRepeated(i))
				printf("*");
			delete node;
		}
	}

	switch (pa->getFrameType()) {

		case pa->FRAME_I:
			printf(
				" I%i%i (PID:%2x Len:%3i)\n",
				pa->getReceiveSequence(),
				pa->getSendSequence(),
				pa->getPID(),
				pa->getInfoLength()
			);
			displayText(pa);
			break;

		case pa->FRAME_S:
			switch(pa->getSFrameType()) {
				case pa->SFRAME_RR:  printf(" RR");  break;
				case pa->SFRAME_RNR: printf(" RNR"); break;
				case pa->SFRAME_REJ: printf(" REJ"); break;
				default:             printf(" S?");
			}
			printf("%i", pa->getReceiveSequence());
			break;

		case pa->FRAME_U:
			switch(pa->getUFrameType()) {
				case pa->UFRAME_UI:
					printf(
						" UI (PID:%2x Len:%3i)\n",
						pa->getPID(),
						pa->getInfoLength()
					);
					displayText(pa);
					break;
				case pa->UFRAME_DM:   printf(" DM");   break;
				case pa->UFRAME_SABM: printf(" SABM"); break;
				case pa->UFRAME_DISC: printf(" DISC"); break;
				case pa->UFRAME_UA:   printf(" UA");   break;
				case pa->UFRAME_FRMR: printf(" FRMR"); break;
				default:              printf(" U?");
			}
			break;

		default: printf(" ?");

	}
	printf("\n");
}
