/*
 * factory.h - PacketFactory - produces commonly used packet types
 *
 * Written by Michael "Mr. Sump" Poppitz.
 *
 */

 /***************************************************************************
  *                                                                         *
  *   This program is free software; you can redistribute it and/or modify  *
  *   it under the terms of the GNU General Public License as published by  *
  *   the Free Software Foundation; either version 2 of the License, or     *
  *   (at your option) any later version.                                   *
  *                                                                         *
  ***************************************************************************/

#ifndef FACTORY_H
#define FACTORY_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "call.h"
#include "packet.h"

class PacketFactory {
	public:
		PacketFactory(char *device);
		~PacketFactory();

		Packet *produceSABM(Call *src, Call *dest);
		Packet *produceDISC(Call *src, Call *dest);
		Packet *produceUA(Call *src, Call *dest);
		Packet *produceDM(Call *src, Call *dest);
		Packet *produceUI(Call *src, Call *dest, char *msg);
		Packet *produceBeacon(Call *src, Call *dest, char *msg);

		Packet *produceI(Call *src, Call *dest, int pid, unsigned char *text, int len, int rseq, int sseq, bool cr);

	private:
		void setBasics(Packet *p, Call *src, Call *dest);

		const static int DEVICE_MAXLEN = 32;
		char device[DEVICE_MAXLEN + 1];
};

#endif

/**** That's all *********************************************************/
