/*
 * factory.cpp - PacketFactory - produces commonly used packet types
 *
 * Written by Michael "Mr. Sump" Poppitz.
 *
 */

 /***************************************************************************
  *                                                                         *
  *   This program is free software; you can redistribute it and/or modify  *
  *   it under the terms of the GNU General Public License as published by  *
  *   the Free Software Foundation; either version 2 of the License, or     *
  *   (at your option) any later version.                                   *
  *                                                                         *
  ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "packet.h"
#include "factory.h"

PacketFactory::PacketFactory(char *device) {
	int l = strlen(device);
	if (l > DEVICE_MAXLEN)
		l = DEVICE_MAXLEN;

	memcpy((void *)PacketFactory::device, (void *)device, l);
	PacketFactory::device[l] = 0;
}

PacketFactory::~PacketFactory() {
}

Packet *PacketFactory::produceSABM(Call *src, Call *dest) {
	Packet *p = new Packet();
	setBasics(p, src, dest);
	p->setFrameType(p->FRAME_U, p->UFRAME_SABM);
	return (p);
}

Packet *PacketFactory::produceDISC(Call *src, Call *dest) {
	Packet *p = new Packet();
	setBasics(p, src, dest);
	p->setFrameType(p->FRAME_U, p->UFRAME_DISC);
	return (p);
}


Packet *PacketFactory::produceUA(Call *src, Call *dest) {
	Packet *p = new Packet();
	setBasics(p, src, dest);
	p->setFrameType(p->FRAME_U, p->UFRAME_UA);
	return (p);
}

Packet *PacketFactory::produceDM(Call *src, Call *dest) {
	Packet *p = new Packet();
	setBasics(p, src, dest);
	p->setFrameType(p->FRAME_U, p->UFRAME_DM);
	return (p);
}

Packet *PacketFactory::produceUI(Call *src, Call *dest, char *msg) {
	Packet *p = new Packet();
	setBasics(p, src, dest);
	p->setFrameType(p->FRAME_U, p->UFRAME_UI);
	p->setInfo((unsigned char *)msg, strlen(msg));
	return (p);
}

Packet *PacketFactory::produceBeacon(Call *src, Call *dest, char *msg) {
	return (produceUI(src, dest, msg));
}

Packet *PacketFactory::produceI(Call *src, Call *dest, int pid, unsigned char *text, int len, int rseq, int sseq, bool cr) {
	Packet *p = new Packet();
	setBasics(p, src, dest);

	if (cr) {
		p->setCommand();
	} else {
		p->setResponse();
	}

	p->setSendSequence(sseq);
	p->setReceiveSequence(rseq);

	p->setFrameType(p->FRAME_I, pid);
	p->setInfo(text, len);

	return (p);
}

void PacketFactory::setBasics(Packet *p, Call *src, Call *dest) {
	p->setDevice(device);
	p->setSourceCall(src);
	p->setDestinationCall(dest);
	p->setRepeaterCount(0);

	p->setCommand();
}

/**** That's all *********************************************************/
