/*
 * call.cpp - Call - a callsign including ssid
 *
 * Written by Michael "Mr. Sump." Poppitz.
 *
 */

 /***************************************************************************
  *                                                                         *
  *   This program is free software; you can redistribute it and/or modify  *
  *   it under the terms of the GNU General Public License as published by  *
  *   the Free Software Foundation; either version 2 of the License, or     *
  *   (at your option) any later version.                                   *
  *                                                                         *
  ***************************************************************************/



#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "call.h"

Call::Call(char *str) {
	int num;
	char call[7];
	char *ssid = strrchr(str, '-');

	if (!ssid) {
		init(str, 0, false);

	} else {
		int l = (int )(ssid - str);
		if (l > 6)
			l = 6;

		memcpy((void *)call, (void *)str, l);
		call[l] = 0;

		if (sscanf(++ssid, "%i", &num)) {
			init(call, num, false);
		} else {
			init(call, 0, false);
		}
	}
}

Call::Call(char *call, int ssid) {
	init(call, ssid, false);
}

Call::Call(char *call, int ssid, bool raw) {
	init(call, ssid, raw);
}

Call::~Call() {
}

void Call::init(char *call, int ssid, bool raw) {
	int l;
	if (raw) {
		/* assume prebuild call string */
		l = 6;
	} else {
		/* determine length, if bigger use possible max. */
		l = strlen(call);
		if (l > 6)
			l = 6;
	}

	/* get a copy of the call sign */
	memcpy((void *)Call::call, (void *)call, l);
	Call::call[6] = 0;

	/* fill up with spaces */
	if (l < 6)
		for (; l < 6; l++)
			Call::call[l] = 0x20;

	/* set given ssid - if not possible use the closest one */
	Call::ssid = ssid;
	if (ssid < 0)
		Call::ssid = 0;
	if (ssid > 15)
		Call::ssid = 15;

	/* strip the highest bit, ax.25 only uses 7 per char */
	for (int i = 0; i < 6; i++)
		Call::call[i] &=0x7f;
}


/**** That's all *********************************************************/
