/*
 * trx.cpp - TRX - receives and transmits packets
 *
 * Written by Michael "Mr. Sump." Poppitz
 *
 */

 /***************************************************************************
  *                                                                         *
  *   This program is free software; you can redistribute it and/or modify  *
  *   it under the terms of the GNU General Public License as published by  *
  *   the Free Software Foundation; either version 2 of the License, or     *
  *   (at your option) any later version.                                   *
  *                                                                         *
  ***************************************************************************/



#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>

#include "trx.h"
#include "packet.h"

TRX::TRX() {
	sas = 0;
	sock = 0;
}

TRX::~TRX() {
	close(sock);
}

int TRX::init() {
	return (sock = socket(PF_PACKET, SOCK_RAW, htons(ETH_P_AX25)));
}

Packet *TRX::rx() {
	struct sockaddr_ll s;
	unsigned int ss = sizeof(struct sockaddr_ll);

	if (sock <= 0)
		return (NULL);

	Packet *pa = new Packet();
	char *buffer = (char *)pa->getDataPointer();
	int len = pa->DATA_LIMIT;
	
	int l = recvfrom(sock, buffer, len, 0, (sockaddr *)&s, &ss);
	if (l > 0) {
		pa->setDataLength(l);
		char tmp[IFNAMSIZ];
		getInterfaceName(tmp, s.sll_ifindex);
		pa->setDevice(tmp);
	} else {
		delete pa;
		pa = NULL;
	}
	return (pa);
}

int TRX::tx(Packet *pa) {
	char dev[sizeof(struct ifreq)];

	if (sock == 0)
		return (ERROR);

	pa->getDevice(dev);
	int ifindex = getInterfaceIndex(dev);
	if (ifindex == ERROR)
		return (ERROR);

	sas = sizeof(struct sockaddr_ll);
	sa.sll_family = AF_PACKET;
	sa.sll_protocol = PF_AX25;
	sa.sll_ifindex = ifindex;

	return (sendto(sock, pa->getDataPointer(), pa->getDataLength(), 0, (sockaddr *)&sa, sas) < 0);
}

int TRX::tx(char *device, Packet *pa) {
	pa->setDevice(device);
	tx(pa);
}

/**** Internal methods ***************************************************/

int TRX::getInterfaceIndex(char *device) {
	if (strlen(device) > IFNAMSIZ)
		return (ERROR);

	struct ifreq ir;
	strcpy(ir.ifr_name, device);
	ioctl(sock, SIOCGIFINDEX, &ir);

	return (ir.ifr_ifindex);
}

void TRX::getInterfaceName(char *name, int ifindex) {
	struct ifreq ir;
	ir.ifr_ifindex = ifindex;
	ioctl(sock, SIOCGIFNAME, &ir);
	strcpy(name, ir.ifr_name);
}

/**** That's all *********************************************************/
