/***************************************************************************
                    r2eboot.c  -  reboot device control
                             -------------------
    begin                : Sat Sep 23 2000
    last update          : Sun Sep 24 2000
    version              : 0.0.2
    copyright            : (C) 2000 by Michael "Mr. Sump" Poppitz
    email                : sump@sump.org
    website              : http://www.sump.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
   NOTE: This program must be compiled with optimization turned on in order
         to process the outb macro.
 ***************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <sys/io.h>

int	portlist[] = {0x3bc, 0x378, 0x278, 0x3bc, 0};
int	base = 0x378; /* used parport - defaults to 0x378 */
char	*myname;

void info() {
	int i;

	/* display usage */
	printf(
		"Usage: %s [-p <num>]\n"
		"\n"
		"Where <num> can be one of the following:\n", myname
	);

	/* compile list of available ports */
	for (i = 0; portlist[i]; i++)
		printf("   %2i for base address 0x%3x\n", i, portlist[i]);

	/* display default port address */
	printf("\nIf the -p option is not used, the program defaults to base address 0x%3x.\n\n", base);
	exit(0);
}

int getport(char *s) {
	int val, i;
	
	sscanf(s, "%i", &val);
	for (i = 0; portlist[i]; i++);
	if (val < 0 || val >= i) {
		puts("ERROR: Invalid port number specified.\n");
		info();
	}
	return (portlist[val]);
}

int main(int argc, char *argv[]) {
	char	expect_val = 0;
	int	i;
	
	/* set pointer to program name */
	myname = argv[0];
	
	/* parse arguments */
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			switch(argv[i][1]) {
				case 'p':
					if (strlen(argv[i]) > 2) {
						base = getport(argv[i] + 2);
					} else {
						expect_val = 1;
					}
					break;
				default:
					info();
			}
		} else if (expect_val) {
			expect_val = 0;
			base = getport(argv[i]);
		} else
			info();
	}

	/* try to get permissions for low level access */
	if (ioperm(base, 3, 2)) {
		perror("ioperm");
		puts("This program must be run with root permissions.");
		exit(0);
	}

	/* activate reset signal (10101110)*/
	outb(174, base);

	/* keep it one second */
	sleep(1);

	/* deactivate reset signal */
	outb(0, base);

	return (0);
}
