#ifndef STREAM_H
#define STREAM_H

#include <stdio.h>
#include <stdlib.h>
#include "config.h"

struct stream {
	FILE *file;
	char cache[HEADER_MAXSIZE + 1];
	char resource[RESOURCE_MAXSIZE + 1];
	u_int32_t outstanding;
	u_int32_t used;
	int type;
	struct stream *twin;
};

int streamCount;

void streamInit();

void streamOpen(struct stream *s);
void streamWrite(struct stream *stream, char *data, u_int32_t size);
void streamClose(struct stream *s);

#endif
