/*
 * HTTPSniff v0.3 - HTTP Response Sniffer
 * nids.c
 * (C)2004-2005 Michael Poppitz
 *
 * This file contains the interface to libnids.
 *
 */

#include <string.h>
#include <nids.h>

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "hash.h"
#include "stream.h"

/* the following line has been stolen from the official libnids example :)
   i'm not sure why libnids isn't using struct in_addr if their own example relies on its existence */
#define int_ntoa(x)     inet_ntoa(*((struct in_addr *)&x))

/* helper function for debugging output */
void nidsDebug(struct tuple4 *addr, char *mesg) {
	char source[16];

	strncpy(source, int_ntoa(addr->saddr), 15);
	printf(
		"(%s:%i->%s:%i) -- %s\n",
		source,
		addr->source,
		int_ntoa(addr->daddr),
		addr->dest,
		mesg
	);	
}

// create address tuple for opposite direction
void nidsTwin(struct tuple4 *dst, struct tuple4 *src) {
	dst->daddr = src->saddr;
	dst->saddr = src->daddr;
	dst->source = src->dest;
	dst->dest = src->source;
}

void nidsCallback(struct tcp_stream *ns, void **param) {
	struct stream *si[2], *s;
	struct half_stream *hs;
	struct tuple4 a;
	int i;

	if (debug > 5) printf("\n*** Callback from libnids ***\n");                
	
	memcpy(&a, &ns->addr, sizeof(struct tuple4));
	
	switch (ns->nids_state) {

		case NIDS_JUST_EST:
			ns->client.collect++;
			ns->server.collect++;
			// create one stream for each libnids "half stream"
			for (i = 0; i < 2; i++) {
				if (!(si[i] = malloc(sizeof(struct stream)))) {
					printf("nidsCallback(): Oops: Could not allocate stream memory.\n");
					return;
				}
				if(!hashAdd(&a, si[i])) {
					printf("nidsCallback(): Oops: Connection limit exceeded.\n");
					free(si[i]);
					return;
				}
				if (debug > 4) nidsDebug(&a, "Connection established.");
				streamOpen(si[i]);
				nidsTwin(&a, &ns->addr);
			}
			// connect twins
			if (si[0] != NULL && si[1] != NULL) {
				si[0]->twin = si[1];
				si[1]->twin = si[0];
			}
			break;

		case NIDS_DATA:
			hs = &ns->server;
			// process data for each half stream
			for (i = 0; i < 2; i++) {
				if (hs->count_new) {
					if (!(s = hashFind(&a))) {
						printf("nidsCallback(): Oops: Received data for unexisting connection. Ignoring.\n");
					} else {
						if (debug > 4) nidsDebug(&a, "Processing data...");
						streamWrite(s, (char *)hs->data, hs->count_new);
					}
				}
				hs = &ns->client;
				nidsTwin(&a, &ns->addr);
			}
			break;

		default:
			// close both stream assigned to libnids stream
			for (i = 0; i < 2; i++) {
				if (!(s = hashDelete(&a))) {
					printf("nidsCallback(): Oops: Attempted to close unexisting connection. Ignoring.\n");
					return;
				}
				if (debug > 4) nidsDebug(&a, "Connection closed.");
				streamClose(s);
				nidsTwin(&a, &ns->addr);
			}
	}
}

int nidsRun(char *filter) {
	nids_params.pcap_filter = filter;
	nids_params.n_tcp_streams = (MAX_CONNECTIONS * 2) / 3 + 1; /* libnids allows 3/4 * n simultaneous twin connections */
	if (!nids_init())
		return (-1);

	hashInit();
	streamInit();

	nids_register_tcp(nidsCallback);
	nids_run();
	
	return (0);
}

int nidsAvailable() {
	return (-1);
}

int nidsFile(char *file, char *filter) {
	nids_params.filename = file;
	return (nidsRun(filter));
}


int nidsDevice(char *dev, char *filter) {
	nids_params.device = dev;
	return (nidsRun(filter));
}
