/*
 * HTTPSniff v0.3 - HTTP Response Sniffer
 * http.c
 * (C)2005 Michael Poppitz
 *
 * Performs basic HTTP Parsing.
 *
 */
 
#include <stdio.h>
#include <string.h>

#include "config.h"
#include "http.h"

// case insensitive strstr fake - incorrect but sufficient
char *stristr(char *haystack, char *needle) {
	char *start, *hp, *np;

	for (start = haystack; *start != 0; start++) {
		for (hp = start, np = needle; *hp != 0 && *np != 0; hp++, np++)
			if (*hp != *np && *hp + 0x20 != *np)
				break;
		if (*np == 0)
			return (start);
	}

	return (NULL);
}

int httpIsResponse(char *hdr) {
	if(strncmp(hdr, "HTTP", 4))
		return (0);

	if (!strstr(hdr, "\r\n\r\n"))
		return (0);

	return (1);
}

int httpIsRequest(char *hdr) {
	if (strncmp(hdr, "GET ", 3) && strncmp(hdr, "HEAD ", 4) && strncmp(hdr, "POST ", 4))
		return (0);

	if (!strstr(hdr, "\r\n\r\n"))
		return (0);

	return (1);
}

int httpIsChunkHeader(char *hdr) {
	if (
		(
			(hdr[0] >= '0' && hdr[0] <= '9')
			|| (hdr[0] >= 'a' && hdr[0] <= 'f')
			|| (hdr[0] >= 'A' && hdr[0] <= 'F')
		)
		&& strstr(hdr, "\r\n")
	) {
		return (1);
	} else {
		return (0);
	}
}

char *httpHeaderEnd(char *hdr) {
	if (!httpIsChunkHeader(hdr)) {
		return (strstr(hdr, "\r\n\r\n") + 4);
	} else {
		return (strstr(hdr, "\r\n") + 2);
	}
}

int httpType(char *hdr) {
	char *end, *pos;
	
	if (httpIsRequest(hdr))
		return (HTTP_REQUEST);
	
	if (!httpIsResponse(hdr))
		return (HTTP_UNKNOWN);

	end = strstr(hdr, "\r\n\r\n") + 4;

	pos = stristr(hdr, "transfer-encoding: chunked");
	if (pos && pos < end)
		return (HTTP_CHUNK);

	pos = stristr(hdr, "content-length: ");
	if (pos && pos < end)
		return (HTTP_KEEP);

	/* keep-alive and no content-length means this response portion can be ignored */
	pos = stristr(hdr, "connection: keep-alive");
	if (pos && pos < end)
		return (HTTP_DISCARD);
	
	return (HTTP_SIMPLE);
}

char httpContentTypeBuffer[14];

char *httpFileType(char *hdr) {
	char *unknown = "unknown";
	char *pos, *end;
	int i;
	
	end = httpHeaderEnd(hdr);
	pos = stristr(hdr, "content-type: ");

	if (pos && pos < end) { 
		pos = strchr(pos + 14, '/') + 1;
		for (i = 0; i < 10; i++) {
			httpContentTypeBuffer[i] = pos[i];
		
			if (
				httpContentTypeBuffer[i] == '\r'
				|| httpContentTypeBuffer[i] == ';'
				|| httpContentTypeBuffer[i] == ' '
			)
				httpContentTypeBuffer[i] = 0;
			if (httpContentTypeBuffer[i] == 0)
				break;
		}
		httpContentTypeBuffer[i] = 0;
	} else {
		strcpy(httpContentTypeBuffer, unknown);
	}

	pos = stristr(hdr, "content-encoding: gzip");
	if (pos && pos < end)
		strcat(httpContentTypeBuffer, ".gz");
	
	return (httpContentTypeBuffer);
}

char httpResourceBuffer[RESOURCE_MAXSIZE + 1];
const char *httpIndexFile = HTTP_INDEXFILE;

/* return an http resource name contained in a request */
char *httpResource(char *hdr) {
	char *start;
	int len, used;
	
	used = 0;
	
	/* try to get server host name */
	start = stristr(hdr, "host: ");
	if (start) {
		start += 6;
		len = index(start, '\r') - start;
		if (len > 0) {
			if (len > RESOURCE_MAXSIZE)
				len = RESOURCE_MAXSIZE;
			strncpy(httpResourceBuffer, start, len);
			httpResourceBuffer[len] = 0;
			used += len;
		}
	}	
	
	/* read resource name from first request line */
	start = index(hdr, ' ') + 1;
	if (start) {
		len = index(start, ' ') - start;
		if (len > 0) {
			if (len > RESOURCE_MAXSIZE - used)
				len = RESOURCE_MAXSIZE - used;
			strncat(httpResourceBuffer, start, len);
			used += len;
		}
	}
		
	/* check if index file name needs to be added */
	if (used == 0 || httpResourceBuffer[used - 1] == '/') {
		len = strlen(httpIndexFile);
		if (len > RESOURCE_MAXSIZE - used)
			len = RESOURCE_MAXSIZE - used;
		strncat(httpResourceBuffer, httpIndexFile, len);
	}
		
	return (httpResourceBuffer);
}

u_int32_t httpContentLength(char *hdr) {
	char *pos, *end;
	u_int32_t len;
	
	len = 0;
	end = httpHeaderEnd(hdr);
	pos = stristr(hdr, "content-length: ");
	if (pos && pos < end)
		if (pos[16] >= '0' && pos[16] <= '9')
			sscanf(pos + 16, "%u", &len);
	
	return (len);
}

u_int32_t httpChunkLength(char *hdr) {
	u_int32_t len;

	if (httpIsChunkHeader(hdr)) {
		sscanf(hdr, "%x", &len);
	} else {
		len = 0;
	}

	return (len);
}
