#ifndef SEGMENT_H
#define SEGMENT_H

#include <stdlib.h>

/* holds a list of received fragments for a connection */
struct segment {
	u_int32_t seq;
	u_int32_t size;
	u_char *data;
	u_char flags;
	struct segment *next;
	struct segment *prev;
};

#define SEGMENT_FLAG_CLOSE 1


void segmentDump(struct segment *seg);
struct segment *segmentFind(struct segment *seg, u_int32_t seq);
void segmentAdd(struct segment **seg, u_int32_t seq, u_char *packet, u_int32_t len, u_char flags);
void segmentDelete(struct segment **seg, u_int32_t seq);
void segmentFree(struct segment **seg);

#endif
