/*
 * HTTPSniff v0.2 - HTTP Response Sniffer
 * segment.c
 * (C)2004-2005 Michael Poppitz
 *
 * Management functions for TCP segments.
 *
 */

#include <stdio.h> 
#include <string.h>

#include "segment.h"


// output segment list (debugging)

void segmentDump(struct segment *seg) {
	for (; seg; seg = seg->next)
		printf("	seq: %u, size: %u, flags: %i\n", seg->seq, seg->size, seg->flags);
}

// find segment with matching sequence number
struct segment *segmentFind(struct segment *seg, u_int32_t seq) {
	for (; seg; seg = seg->next)
		if (seg->seq == seq)
			return (seg);

	return (NULL);
}

// add a segment to list
void segmentAdd(struct segment **seg, u_int32_t seq, u_char *packet, u_int32_t len, u_char flags) {
	struct segment *newSeg;
	
	// populate segment structure
	newSeg = malloc(sizeof(struct segment));
	if (!newSeg) {
		perror("segmentAdd(): Cannot add segment");
		return;
	}
	
	if (packet != NULL) {
		newSeg->data = malloc(len);
		if (!newSeg->data) {
			free(newSeg);
			perror("segmentAdd(): Cannot add segment");
			return;
		}
		memcpy(newSeg->data, packet, len);
	}
	newSeg->size = len;
	newSeg->seq = seq;
	newSeg->prev = NULL;
	newSeg->flags = flags;
	
	// store fragment in chain
	if (*seg) {
		newSeg->next = *seg;
		(*seg)->prev = newSeg;
	} else {
		newSeg->next = NULL;
	}
	*seg = newSeg;
}

/* deletes all segments which are obsoleted by given sequence */
void segmentDelete(struct segment **seg, u_int32_t seq) {
	struct segment *cur, *next;
	
	for (cur = *seg; cur; cur = next) {
		next = cur->next;
		if (cur->seq <= seq) {
			if (cur->prev) {
				cur->prev->next = cur->next;
			} else {
				*seg = cur->next;
			}
			if (cur->next) {
				cur->next->prev = cur->prev;
			}
			free(cur->data);
			free(cur);
		}
	}
}

/* deletes all segments of a connection */
void segmentFree(struct segment **seg) {
	struct segment *cur, *next;
	
	for (cur = *seg; cur; cur = next) {
		next = cur->next;
		free(cur->data);
		free(cur);
	}
}
