/*
 * HTTPSniff v0.2 - HTTP Response Sniffer
 * http.c
 * (C)2005 Michael Poppitz
 *
 * Performs basic HTTP Parsing.
 *
 */
 
#include <stdio.h>
#include <string.h>

#include "http.h"

// case insensitive strstr fake - incorrect but sufficient
u_char *stristr(u_char *haystack, u_char *needle) {
	u_char *start, *hp, *np;

	for (start = haystack; *start != 0; start++) {
		for (hp = start, np = needle; *hp != 0 && *np != 0; hp++, np++)
			if (*hp != *np && *hp + 0x20 != *np)
				break;
		if (*np == 0)
			return (start);
	}

	return (NULL);
}

int httpIsHeader(u_char *hdr) {
	if(strncmp(hdr, "HTTP", 4))
		return (0);

	if (!strstr(hdr, "\r\n\r\n"))
		return (0);

	return (1);
}

int httpIsChunkHeader(u_char *hdr) {
	if (
		(
			(hdr[0] >= '0' && hdr[0] <= '9')
			|| (hdr[0] >= 'a' && hdr[0] <= 'f')
			|| (hdr[0] >= 'A' && hdr[0] <= 'F')
		)
		&& strstr(hdr, "\r\n")
	) {
		return (1);
	} else {
		return (0);
	}
}

char *httpHeaderEnd(u_char *hdr) {
	if (!httpIsChunkHeader(hdr)) {
		return (strstr(hdr, "\r\n\r\n") + 4);
	} else {
		return (strstr(hdr, "\r\n") + 2);
	}
}

int httpType(u_char *hdr) {
	u_char *end, *pos;
	
	if (!httpIsHeader(hdr))
		return (HTTP_UNKNOWN);

	end = strstr(hdr, "\r\n\r\n") + 4;

	pos = stristr(hdr, "transfer-encoding: chunked");
	if (pos && pos < end)
		return (HTTP_CHUNK);

	pos = stristr(hdr, "content-length: ");
	if (pos && pos < end)
		return (HTTP_KEEP);

	// keep-alive and no content-length means this response portion can be ignored
	pos = stristr(hdr, "connection: keep-alive");
	if (pos && pos < end)
		return (HTTP_DISCARD);
	
	return (HTTP_SIMPLE);
}

char httpContentTypeBuffer[14];

char *httpFileType(u_char *hdr) {
	char *unknown = "unknown";
	u_char *pos, *end;
	int i;
	
	end = httpHeaderEnd(hdr);
	pos = stristr(hdr, "content-type: ");

	if (pos && pos < end) { 
		pos = strchr(pos + 14, '/') + 1;
		for (i = 0; i < 10; i++) {
			httpContentTypeBuffer[i] = pos[i];
		
			if (
				httpContentTypeBuffer[i] == '\r'
				|| httpContentTypeBuffer[i] == ';'
				|| httpContentTypeBuffer[i] == ' '
			)
				httpContentTypeBuffer[i] = 0;
			if (httpContentTypeBuffer[i] == 0)
				break;
		}
		httpContentTypeBuffer[i] = 0;
	} else {
		strcpy(httpContentTypeBuffer, unknown);
	}

	pos = stristr(hdr, "content-encoding: gzip");
	if (pos && pos < end)
		strcat(httpContentTypeBuffer, ".gz");
	
	return (httpContentTypeBuffer);
}

u_int32_t httpContentLength(u_char *hdr) {
	u_char *pos, *end;
	u_int32_t len;
	
	len = 0;
	end = httpHeaderEnd(hdr);
	pos = stristr(hdr, "content-length: ");
	if (pos && pos < end)
		if (pos[16] >= '0' && pos[16] <= '9')
			sscanf(pos + 16, "%u", &len);
	
	return (len);
}

u_int32_t httpChunkLength(u_char *hdr) {
	u_int32_t len;

	if (httpIsChunkHeader(hdr)) {
		sscanf(hdr, "%x", &len);
	} else {
		len = 0;
	}

	return (len);
}
