; ======================================================================
; Frequency Counter Software
;
; timer.asm
;
; Copyright (C) 2005 Michael Poppitz
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or (at
; your option) any later version.
;
; This program is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
; General Public License for more details.
;
; You should have received a copy of the GNU General Public License along
; with this program; if not, write to the Free Software Foundation, Inc.,
; 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
;
; ======================================================================
; For details see: http://www.sump.org/projects/counter/
;
; Contains timer mode specific code
; ======================================================================

.cseg

;===== initialisation for timer mode ===================================

init_timer:
	ldi	a, 0b00000000		; normal operation
	out	TCCR1A, a
	ldi	a, 0b10000001		; noise canceler, count using system clock
	out	TCCR1B, a

	ldi	a, 0b00100101		; enable timer0 & 1 overflow & ic int
	out	TIMSK, a

	ldi	i, timerVarEnd - timerVarStart
	ldi	yl, low(timerVarStart)
	ldi	yl, high(timerVarStart)
	clr	a

init_timer_clr_next:
	st	Y+, a			; clear variables
	dec	i
	brne	init_timer_clr_next

	ldi	a, 0b11111101		; clear pending interrupts
	out	TIFR, a

	ret

;===== read timer value ================================================

read_timer:
	ldi	yl, low(timerCurVal)	; select current timer value
	ldi	yh, high(timerCurVal)

	in	a, ICR1L		; read value of input capture
	st	Y+, a
	in	a, ICR1H
	st	Y+, a
	mov	a, count_val
	st	Y+, a

	ldi	yl, low(timerPeriods)	; select number of periods
	ldi	yh, high(timerPeriods)

	ldd	c, Y+2			; read value
	ldd	b, Y+1
	ld	a, Y

	ldi	d, 1
	clr	e

	add	a, d			; increase by one
	adc	b, e
	adc	c, e

	st	Y+, a			; write back
	st	Y+, b
	st	Y+, c	

	ret

;===== calculate frequency =============================================

calc_timer:

	ldi	yl, low(timerCurVal)	; select current timer value
	ldi	yh, high(timerCurVal)

	ld	fb0, Y+			; read value of input capture
	ld	fb1, Y+
	ld	fb2, Y+

	ldi	yl, low(timerLastVal)	; select last timer value
	ldi	yh, high(timerLastVal)

	ldd	c, Y+2			; read last timer value
	ldd	b, Y+1
	ld	a, Y

	st	Y+, fb0			; store new value
	st	Y+, fb1
	st	Y+, fb2

	sub	fb0, a			; get difference
	sbc	fb1, b
	sbc	fb2, c
	clr	fb3			; fill up with zero
	ldi	fbe, 32			; set proper exponent

	ldi	yl, low(timerPeriods)	; select number of periods
	ldi	yh, high(timerPeriods)

	ld	fa0, Y			; read
	ldd	fa1, Y+1
	ldd	fa2, Y+2		
	clr	fa3			; fill up with zero
	mov	fae, fbe		; same exponent as divisor

	clr	e			; reset period counter
	st	Y+, e
	st	Y+, e
	st	Y+, e

	rcall	div32f8			; fr = fa / fb (32+8bit float)		

	mov	fa0, fr0		; fa = fr
	mov	fa1, fr1
	mov	fa2, fr2
	mov	fa3, fr3
	mov	fae, fre

	clr	fb0			; fb = 16.000.000
	ldi	a, 0x24
	mov	fb1, a
	ldi	a, 0xf4
	mov	fb2, a
	clr	fb3
	ldi	fbe, 32

	rcall	mul32f8			; fr = fa * fb

	rcall	show			; display value of fr

	ret

;===== variables =======================================================

.dseg 

timerVarStart:

timerCurVal:	.byte 3			; current timer value
timerLastVal:	.byte 3			; last timer value
timerPeriods:	.byte 3			; number of captures

timerVarEnd:
