; ======================================================================
; Frequency Counter Software
;
; math.asm
;
; Copyright (C) 2005 Michael Poppitz
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or (at
; your option) any later version.
;
; This program is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
; General Public License for more details.
;
; You should have received a copy of the GNU General Public License along
; with this program; if not, write to the Free Software Foundation, Inc.,
; 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
;
; ======================================================================
; For details see: http://www.sump.org/projects/counter/
;
; Functions for multiplying and dividing 32.8 floating point numbers
; ======================================================================
.cseg

;===== multiply two 32+8 bit floating point numbers (fa*fb = fr)

mul32f8:
	push	i
	push	e
	push	d
	push	c
	push	b
	push	a

	;=== low word a * low word b
	rcall	mul16
	rcall	mul16
		
	mov	a, fr0
	mov	b, fr1
	mov	c, fr2
	mov	d, fr3

	;=== + high word a * low word b

	mov     e, fa0
	mov     fa0, fa2
	mov     fa2, e
	mov     e, fa1
	mov     fa1, fa3
	mov     fa3, e

	rcall   mul16

	clr     e
	add     c, fr0
	adc     d, fr1
	adc     fr2, e
	adc     fr3, e
	mov     fr0, fr2
	mov     fr1, fr3

	;=== + high word a * high word b

	mov     e, fb0
	mov     fb0, fb2
	mov     fb2, e
	mov     e, fb1
	mov     fb1, fb3
	mov     fb3, e

	push    fr1
	push    fr0

	rcall   mul16

	pop     e
	add     fr0, e
	pop     e
	adc     fr1, e
	clr     e
	adc     fr2, e
	adc     fr3, e

	;=== + low word a * high word b

	mov     e, fa0
	mov     fa0, fa2
	mov     fa2, e
	mov     e, fa1
	mov     fa1, fa3
	mov     fa3, e

	push    fr3
	push    fr2
	push    fr1
	push    fr0

	rcall   mul16

	add     c, fr0
	adc     d, fr1
	pop     fr0
	pop     fr1
	adc     fr0, fr2
	adc     fr1, fr3
	pop     fr2
	pop     fr3
	clr     e
	adc     fr2, e
	adc     fr3, e

	;=== calculate new exponent

	mov     fre, fae
	add     fre, fbe

	;=== normalize

	ldi	i, 32

mul32f8_norm:
	bst     fr3, 7
	brts    mul32f8_done

	clc
	rol	a
	rol	b
	rol	c
	rol	d
	rol	fr0
	rol	fr1
	rol	fr2
	rol	fr3
	dec	fre
	dec	i
	brne	mul32f8_norm

mul32f8_done:
	pop	a
	pop	b
	pop	c
	pop	d
	pop	e
	pop	i
	ret


;===== multiply two 16bit integers (fa1:fa0 * fb1:fb0 = fr3:fr2:fr1:fr0)

mul16:	push	r0
	push	r1
	
	mul     fa0, fb0
	mov     fr0, r0
	mov     fr1, r1

	mul     fa1, fb1
	mov     fr2, r0
	mov     fr3, r1

	mul     fa0, fb1
	add     fr1, r0
	adc     fr2, r1
	clr     r1
	adc     fr3, r1

	mul     fa1, fb0
	add     fr1, r0
	adc     fr2, r1
	clr     r1
	adc     fr3, r1
	
	pop	r1
	pop	r0
	ret

;===== divide two 32+8 bit floating point numbers (fa/fb = fr)

div32f8:
	push	d
	push	c
	push	b
	push	a
	
	clr     fr0
	clr     fr1
	clr     fr2
	clr     fr3
	ldi     a, 64
	mov     fre, a

	clr     a
	clr     b
	clr     c
	clr     d
	
	tst	fa0			; check if a is zero
	brne	div32f8_next
	tst	fa1
	brne	div32f8_next
	tst	fa2
	brne	div32f8_next
	tst	fa3
	brne	div32f8_next

	clr	fr0			; if so, return zero
	clr	fr1
	clr	fr2
	clr	fr3
	clr	fre
	
	rjmp	div32f8_done

div32f8_next:
	clc
	rol     fa0
	rol     fa1
	rol     fa2
	rol     fa3
	rol     a
	rol     b
	rol     c
	rol     d

	clc
	rol     fr0
	rol     fr1
	rol     fr2
	rol     fr3

	cp      d, fb3
	brlo    div32f8_end
	brne    div32f8_sub
	cp      c, fb2
	brlo    div32f8_end
	brne    div32f8_sub
	cp      b, fb1
	brlo    div32f8_end
	brne    div32f8_sub
	cp      a, fb0
	brlo    div32f8_end

div32f8_sub:
	inc     fr0

	sub     a, fb0
	sbc     b, fb1
	sbc     c, fb2
	sbc     d, fb3

div32f8_end:
	dec     fre

	bst     fr3, 7
	brts    div32f8_done

	rjmp    div32f8_next
	
div32f8_done:
	pop	a
	pop	b
	pop	c
	pop	d
	ret

;===== convert a 32+8 float into 32 bit integer (fr)

conv32f8toi:
	push	e

	ldi	e, 32
	
	cp	fre, e
	brlo	conv32f8toi_up
	brne	conv32f8toi_down
	rjmp	conv32f8toi_done
	
conv32f8toi_up:
	clc
	ror	fr3
	ror	fr2
	ror	fr1
	ror	fr0
	inc	fre
	cp	fre, e
	brne	conv32f8toi_up
	rjmp	conv32f8toi_done

conv32f8toi_down:
	clc
	rol	fr0
	rol	fr1
	rol	fr2
	rol	fr3
	dec	fre	
	cp	fre, e
	brne	conv32f8toi_down

conv32f8toi_done:
	pop	e
	ret
