; ======================================================================
; Frequency Counter Software
;
; defs.h
;
; Copyright (C) 2005 Michael Poppitz
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or (at
; your option) any later version.
;
; This program is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
; General Public License for more details.
;
; You should have received a copy of the GNU General Public License along
; with this program; if not, write to the Free Software Foundation, Inc.,
; 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
;
; ======================================================================
; For details see: http://www.sump.org/projects/counter/
;
; Register and constant definitions.
; ======================================================================

;===== configuration ===================================================

.equ crystal = 16			; oscillator freq. in MHz (8 or 16)
.equ rate = 5				; samples per sec (div. of 1000)
.equ calib = 2				; calibration
.equ prescale = 5			; prescaler compensation bit shifts

.equ t0init = 256 - (250 * crystal) / 16; start value for t0 to reach 1kHz

.equ F_TIMER = 0x08			; mode switch: timer
.equ F_COUNT = 0x10			; mode switch: counter
.equ F_PRESCALE = 0x40			; input switch: prescaler

;===== register definitions ============================================

.def io_pos = r0			; led digit counter
.def count_val = r1			; timer1 overflow counter

.def fr0 = r2
.def fr1 = r3
.def fr2 = r4
.def fr3 = r5
.def fre = r6

.def fa0 = r7
.def fa1 = r8
.def fa2 = r9
.def fa3 = r10
.def fae = r11

.def fb0 = r12
.def fb1 = r13
.def fb2 = r14
.def fb3 = r15
.def fbe = r16

.def a = r17				; general use
.def b = r18				; general use
.def c = r19				; general use
.def d = r20				; general use
.def e = r21				; general use
.def f = r22				; general use
.def i = r23				; loop counter

.def scale = r24			; sample timer scaler counter
.def flags = r25			; flags

.def xl = r26				; x-pointer low byte
.def xh = r27				; x-pointer high byte
.def yl = r28				; y-pointer low byte
.def yh = r29				; y-pointer high byte
.def zl = r30				; z-pointer low byte
.def zh = r31				; z-pointer high byte
