//////////////////////////////////////////////////////////////////////////////////
//
// Copyright (C) 2006 Michael Poppitz
//
// Original design by Michael Poppitz in VHDL
// Converted to Verilog (with minor modifications) by Kenneth Tsang
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or (at
// your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
//
//////////////////////////////////////////////////////////////////////////////////
//
// Details: http://www.sump.org/projects/analyzer/
//
// Simple SRAM interface.
//
//////////////////////////////////////////////////////////////////////////////////

module 	sram (
		input clock,
		input [31:0] dataInput,
		output [31:0] dataOutput,
		input read,
		input write,
		inout reg [15:0] ramIO1,
		inout reg [15:0] ramIO2,      
		output [17:0] ramA,
		output ramWE,
		output ramOE,
		output ramCE1,
		output ramUB1,
		output ramLB1,
		output ramCE2,
		output ramUB2,
		output ramLB2
	);

	reg [17:0] address;

	// static memory signals
	assign ramCE1 = 0;
	assign ramUB1 = 0;
	assign ramLB1 = 0;
	assign ramCE2 = 0;
	assign ramUB2 = 0;
	assign ramLB2 = 0;

	assign ramA = address;		// ram address
	assign ramWE = ~write;
	assign ramOE = ~(~write);
	assign dataOutput = {ramIO2, ramIO1};

	// memory io interface state controller
	always @(write, dataInput)
	begin
		if (write)
			begin
				ramIO1 <= dataInput[15:0];
				ramIO2 <= dataInput[31:16];
			end
		else
			begin
				ramIO1 <= 16'bzzzzzzzzzzzzzzzz;
				ramIO2 <= 16'bzzzzzzzzzzzzzzzz;
			end
	end
	
	//memory address controller
	always @(posedge clock)
	begin
		if (write) 
			address <= address + 1;
		else if (read)
			address <= address - 1;
	end
	
endmodule
