//////////////////////////////////////////////////////////////////////////////////
//
// Copyright (C) 2006 Michael Poppitz
//
// Original design by Michael Poppitz in VHDL
// Converted to Verilog (with minor modifications) by Kenneth Tsang
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or (at
// your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
//
//////////////////////////////////////////////////////////////////////////////////
//
// Details: http://www.sump.org/projects/analyzer/
//
// Logic Analyzer top level module. It connects the core with the hardware
// dependend IO modules and defines all inputs and outputs that represent
// phyisical pins of the fpga.
//
// It defines two constants FREQ and RATE. The first is the clock frequency 
// used for receiver and transmitter for generating the proper baud rate.
// The second defines the speed at which to operate the serial port.
//
//////////////////////////////////////////////////////////////////////////////////

module la (
		input resetSwitch,
		input xtalClock,
		input exClock,
		input [31:0] dataInput,
		output ready50,
		input rx,
		output tx,	// why inout in original design?
		input [1:0] speedSwitch,
		inout [15:0] ramIO1,
		inout [15:0] ramIO2,
		output [17:0] ramA,
		output ramWE,
		output ramOE,
		output ramCE1,
		output ramUB1,
		output ramLB1,
		output ramCE2,
		output ramUB2,
		output ramLB2,

//for debugging
		output clock,
		output trxClock,
		output [39:0] cmd, 
		output execute
	);


parameter FREQ = 100000000;		// 100MHz
parameter TRXSCALE = 28;		// 100M / 28 /115200 = 31 (5 bits)
parameter RATE = 115200;		// baud rate

//wire clock, trxClock;
//wire [39:0] cmd;
//wire execute;
wire send, busy;
wire [31:0] dataOutput;
wire [31:0] memoryIn, memoryOut;
wire read, write;

// Module contents

	clockman clockman0 (.inclk0(xtalClock), .c0(clock));

	eia232 eia232_0 (
		.clock(clock),
		.reset(resetSwitch),
		.speed(speedSwitch),
		.rx(rx),
		.tx(tx),
		.cmd(cmd),
		.execute(execute),
		.data(dataOutput),
		.send(send),
		.busy(busy),
		
		.trxClock(trxClock)
	);
	defparam eia232_0.FREQ = FREQ;
	defparam eia232_0.SCALE = TRXSCALE;
	defparam eia232_0.RATE = RATE;

	core core0 (
		.clock(clock),
		.extReset(resetSwitch),
		.cmd(cmd),
		.execute(execute),
		.dataInput(dataInput),
		.inputClock(exClock),
		.sampleReady50(ready50),
		.dataOutput(dataOutput),
		.outputSend(send),
		.outputBusy(busy),
		.memoryIn(memoryIn),
		.memoryOut(memoryOut),
		.memoryRead(read),
		.memoryWrite(write)
	);

	sram sram0 (
		.clock(clock),
		.dataInput(memoryOut),
		.dataOutput(memoryIn),
		.read(read),
		.write(write),
		.ramIO1(ramIO1),
		.ramIO2(ramIO2),
		.ramA(ramA),
		.ramWE(ramWE),
		.ramOE(ramOE),
		.ramCE1(ramCE1),
		.ramUB1(ramUB1),
		.ramLB1(ramLB1),
		.ramCE2(ramCE2),
		.ramUB2(ramUB2),
		.ramLB2(ramLB2)
	);

endmodule
