----------------------------------------------------------------------------------
-- decoder.vhd
--
-- Copyright (C) 2006 Michael Poppitz
-- 
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or (at
-- your option) any later version.
--
-- This program is distributed in the hope that it will be useful, but
-- WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along
-- with this program; if not, write to the Free Software Foundation, Inc.,
-- 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
--
----------------------------------------------------------------------------------
--
-- Details: http://sump.org/projects/analyzer/
--
-- Takes the opcode from the command received by the receiver and decodes it.
-- The decoded command will be executed for one cycle.
--
-- The receiver keeps the cmd output active long enough so all the
-- data is still available on its cmd output when the command has
-- been decoded and sent out to other modules with the next
-- clock cycle. (Maybe this paragraph should go in receiver.vhd?)
--
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity decoder is
   Port ( opcode : in  STD_LOGIC_VECTOR (7 downto 0);
			execute : in std_logic;
	   clock : in std_logic;
      wrtrigmask : out  STD_LOGIC;
      wrtrigval : out  STD_LOGIC;
	   wrspeed : out STD_LOGIC;
	   wrsize : out STD_LOGIC;
		wrFlags : out std_logic;
		arm : out STD_LOGIC;
		reset : out STD_LOGIC;
		id : out std_logic;
		xon : out std_logic;
		xoff : out std_logic
	);
end decoder;

architecture Behavioral of decoder is

signal	exe, exeReg, set: std_logic;
signal	longGo, shortGo : std_logic;
signal	cmd : std_logic_vector(6 downto 0);

begin

	(set, cmd(6), cmd(5), cmd(4), cmd(3), cmd(2), cmd(1), cmd(0)) <= opcode;

	exe <= execute;
	longGo <= exe and set and not exeReg;
	shortGo <= exe and not set and not exeReg;

	process(clock)
	begin
		if rising_edge(clock) then
			-- long commands
			wrtrigmask <= longGo and cmd(6) and not cmd(0);
			wrtrigval <= longGo and cmd(6) and cmd(0);
			wrspeed <= longGo and not cmd(6) and not cmd(1) and not cmd(0);
			wrsize <= longGo and not cmd(6) and not cmd(1) and cmd(0);
			wrFlags <= longGo and not cmd(6) and cmd(1) and not cmd(0);

			-- short commands
			reset <= shortGo and not (cmd(6) or cmd(5) or cmd(4) or cmd(3) or cmd(2) or cmd(1) or cmd(0));
			arm <= shortGo and not cmd(4) and cmd(0);
			id <= shortGo and not cmd(4) and cmd(1);
			xon <= shortGo and cmd(4) and not cmd(1);
			xoff <= shortGo and cmd(4) and cmd(1);

			exeReg <= exe;
		end if;
	end process;

end Behavioral;
