----------------------------------------------------------------------------------
-- decoder.vhd
--
-- Copyright (C) 2006 Michael Poppitz
-- 
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or (at
-- your option) any later version.
--
-- This program is distributed in the hope that it will be useful, but
-- WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along
-- with this program; if not, write to the Free Software Foundation, Inc.,
-- 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
--
----------------------------------------------------------------------------------
--
-- Details: http://sump.org/projects/analyzer/
--
-- Takes the opcode from the command received by the receiver and decodes it.
-- The decoded command will be executed for one cycle.
--
-- The receiver keeps the cmd output active long enough so all the
-- data is still available on its cmd output when the command has
-- been decoded and sent out to other modules with the next
-- clock cycle. (Maybe this paragraph should go in receiver.vhd?)
--
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity decoder is
   Port ( opcode : in  STD_LOGIC_VECTOR (7 downto 0);
			execute : in std_logic;
	   clock : in std_logic;
      wrtrigmask : out  STD_LOGIC;
      wrtrigval : out  STD_LOGIC;
	   wrspeed : out STD_LOGIC;
	   wrsize : out STD_LOGIC;
		wrFlags : out std_logic;
		arm : out STD_LOGIC;
		reset : out STD_LOGIC;
		xon : out std_logic;
		xoff : out std_logic
	);
end decoder;

architecture Behavioral of decoder is

signal	exe, exeReg, set: std_logic;
signal	longGo, shortGo : std_logic;
signal	id : std_logic_vector(6 downto 0);

begin

	(set, id(6), id(5), id(4), id(3), id(2), id(1), id(0)) <= opcode;

	exe <= execute;
	longGo <= exe and set and not exeReg;
	shortGo <= exe and not set and not exeReg;

	process(clock)
	begin
		if rising_edge(clock) then
			-- long commands
			wrtrigmask <= longGo and id(6) and not id(0);
			wrtrigval <= longGo and id(6) and id(0);
			wrspeed <= longGo and not id(6) and not id(1) and not id(0);
			wrsize <= longGo and not id(6) and not id(1) and id(0);
			wrFlags <= longGo and not id(6) and id(1) and not id(0);

			-- short commands
			reset <= shortGo and not (id(6) or id(5) or id(4) or id(3) or id(2) or id(1) or id(0));
			arm <= shortGo and not id(4) and id(0);
			xon <= shortGo and id(4) and not id(1);
			xoff <= shortGo and id(4) and id(1);

			exeReg <= exe;
		end if;
	end process;

end Behavioral;
