/*
 * Decompiled with CFR 0.152.
 */
package org.sump.analyzer.tools;

import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.sump.analyzer.CapturedData;
import org.sump.analyzer.Configurable;
import org.sump.analyzer.tools.Base;
import org.sump.analyzer.tools.Tool;
import org.sump.util.Properties;

public class StateAnalysis
extends Base
implements Tool,
Configurable {
    private StateAnalysisDialog sad;

    public void init(Frame frame) {
        this.sad = new StateAnalysisDialog(frame, this.getName());
    }

    public String getName() {
        return "State Analysis...";
    }

    public CapturedData process(CapturedData data) {
        if (data == null || this.sad == null) {
            return null;
        }
        if (this.sad.showDialog() == 0) {
            return null;
        }
        int number = this.sad.channel;
        int level = this.sad.edge == 0 ? 0 : 1;
        int[] values = data.values;
        int triggerPosition = data.triggerPosition;
        int last = values[0] & 1 << number;
        int size = 0;
        int i = 0;
        while (i < values.length) {
            int current = values[i] & 1 << number;
            if (last == level && current != level) {
                ++size;
            }
            last = current;
            ++i;
        }
        last = values[0] & 1 << number;
        int pos = 0;
        int newTrigger = -1;
        int[] newValues = new int[size];
        int i2 = 0;
        while (i2 < values.length) {
            int current = values[i2] & 1 << number;
            if (last == level && current != level) {
                newValues[pos++] = values[i2 - 1];
            }
            if (triggerPosition == i2) {
                newTrigger = pos;
            }
            last = current;
            ++i2;
        }
        return new CapturedData(newValues, newTrigger, -1, data.channels, data.enabledChannels);
    }

    public void readProperties(Properties properties) {
        this.sad.readProperties(properties);
    }

    public void writeProperties(Properties properties) {
        this.sad.writeProperties(properties);
    }

    private class StateAnalysisDialog
    extends JDialog
    implements ActionListener {
        public static final int CANCEL = 0;
        public static final int OK = 1;
        public static final int RISING = 0;
        public static final int FALLING = 1;
        public int channel;
        public int edge;
        private JComboBox edgeSelect;
        private JComboBox channelSelect;
        private String[] edges;
        private String[] channels;
        private int result;

        public StateAnalysisDialog(Frame frame, String name) {
            super(frame, name, true);
            Container pane = this.getContentPane();
            pane.setLayout(new GridLayout(3, 2, 5, 5));
            this.getRootPane().setBorder(BorderFactory.createLineBorder(this.getBackground(), 5));
            this.channels = new String[32];
            int i = 0;
            while (i < this.channels.length) {
                this.channels[i] = Integer.toString(i);
                ++i;
            }
            this.channelSelect = new JComboBox<String>(this.channels);
            pane.add(new JLabel("Clock Channel:"));
            pane.add(this.channelSelect);
            String[] tmp = new String[]{"Rising", "Falling"};
            this.edges = tmp;
            this.edgeSelect = new JComboBox<String>(this.edges);
            pane.add(new JLabel("Clock Edge:"));
            pane.add(this.edgeSelect);
            JButton convert = new JButton("Convert");
            convert.addActionListener(this);
            pane.add(convert);
            JButton cancel = new JButton("Cancel");
            cancel.addActionListener(this);
            pane.add(cancel);
            this.pack();
            this.setResizable(false);
            this.result = 0;
        }

        public int showDialog() {
            this.show();
            return this.result;
        }

        public void actionPerformed(ActionEvent e) {
            this.channel = Integer.parseInt((String)this.channelSelect.getSelectedItem());
            this.edge = ((String)this.edgeSelect.getSelectedItem()).equals("Rising") ? 0 : 1;
            this.result = e.getActionCommand().equals("Convert") ? 1 : 0;
            this.hide();
        }

        public void readProperties(Properties properties) {
            StateAnalysis.this.selectByValue(this.edgeSelect, this.edges, properties.getProperty("tools.StateAnalysis.edge"));
            StateAnalysis.this.selectByValue(this.channelSelect, this.channels, properties.getProperty("tools.StateAnalysis.channel"));
        }

        public void writeProperties(Properties properties) {
            properties.setProperty("tools.StateAnalysis.channel", (String)this.channelSelect.getSelectedItem());
            properties.setProperty("tools.StateAnalysis.edge", (String)this.edgeSelect.getSelectedItem());
        }
    }
}

