/*
 * Decompiled with CFR 0.152.
 */
package org.sump.analyzer.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import org.sump.analyzer.CapturedData;
import org.sump.analyzer.Configurable;
import org.sump.analyzer.tools.Base;
import org.sump.analyzer.tools.Tool;
import org.sump.util.Properties;

public class SPIProtocolAnalysis
extends Base
implements Tool,
Configurable {
    private SPIProtocolAnalysisDialog spad;

    private static GridBagConstraints createConstraints(int x, int y, int w, int h, double wx, double wy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = wx;
        gbc.weighty = wy;
        return gbc;
    }

    public void init(Frame frame) {
        this.spad = new SPIProtocolAnalysisDialog(frame, this.getName());
    }

    public String getName() {
        return "SPI Protocol Analysis...";
    }

    public CapturedData process(CapturedData data) {
        this.spad.showDialog(data);
        return null;
    }

    public void readProperties(Properties properties) {
        this.spad.readProperties(properties);
    }

    public void writeProperties(Properties properties) {
        this.spad.writeProperties(properties);
    }

    private class SPIProtocolAnalysisDataSet {
        public int time;
        public int miso;
        public int mosi;
        public String event;

        public SPIProtocolAnalysisDataSet(int tm, int mi, int mo) {
            this.time = tm;
            this.miso = mi;
            this.mosi = mo;
            this.event = null;
        }

        public SPIProtocolAnalysisDataSet(int tm, String ev) {
            this.time = tm;
            this.miso = 0;
            this.mosi = 0;
            this.event = new String(ev);
        }

        public boolean isEvent() {
            return this.event != null;
        }
    }

    private class SPIProtocolAnalysisDialog
    extends JDialog
    implements ActionListener {
        private String[] modearray;
        private String[] bitarray;
        private String[] orderarray;
        private JComboBox sck;
        private JComboBox miso;
        private JComboBox mosi;
        private JComboBox cs;
        private JComboBox mode;
        private JComboBox bits;
        private CapturedData analysisData;
        private JTable outTable;
        private JComboBox order;
        private long unitFactor;
        private String unitName;
        private String[] colNames = new String[]{"Index", "Time", "MOSI", "MISO"};
        private Vector decodedData;
        private JFileChooser fileChooser;
        private int startOfDecode;
        private static final long serialVersionUID = 1L;

        public SPIProtocolAnalysisDialog(Frame frame, String name) {
            super(frame, name, true);
            Container pane = this.getContentPane();
            pane.setLayout(new GridBagLayout());
            this.getRootPane().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.decodedData = new Vector();
            this.startOfDecode = 0;
            JPanel panSettings = new JPanel();
            panSettings.setLayout(new GridLayout(7, 2, 5, 5));
            panSettings.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Settings"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            String[] channels = new String[32];
            int i = 0;
            while (i < 32) {
                channels[i] = new String("Channel " + i);
                ++i;
            }
            panSettings.add(new JLabel("SCK"));
            this.sck = new JComboBox<String>(channels);
            panSettings.add(this.sck);
            panSettings.add(new JLabel("MISO"));
            this.miso = new JComboBox<String>(channels);
            panSettings.add(this.miso);
            panSettings.add(new JLabel("MOSI"));
            this.mosi = new JComboBox<String>(channels);
            panSettings.add(this.mosi);
            panSettings.add(new JLabel("/CS"));
            this.cs = new JComboBox<String>(channels);
            panSettings.add(this.cs);
            panSettings.add(new JLabel("Mode"));
            this.modearray = new String[4];
            i = 0;
            while (i < this.modearray.length) {
                this.modearray[i] = new String("" + i);
                ++i;
            }
            this.mode = new JComboBox<String>(this.modearray);
            panSettings.add(this.mode);
            panSettings.add(new JLabel("Bits"));
            this.bitarray = new String[13];
            i = 0;
            while (i < this.bitarray.length) {
                this.bitarray[i] = new String("" + (i + 4));
                ++i;
            }
            this.bits = new JComboBox<String>(this.bitarray);
            this.bits.setSelectedItem("8");
            panSettings.add(this.bits);
            panSettings.add(new JLabel("Order"));
            this.orderarray = new String[2];
            this.orderarray[0] = new String("MSB first");
            this.orderarray[1] = new String("LSB first");
            this.order = new JComboBox<String>(this.orderarray);
            panSettings.add(this.order);
            pane.add((Component)panSettings, SPIProtocolAnalysis.createConstraints(0, 0, 1, 1, 0.0, 0.0));
            JPanel panTable = new JPanel();
            panTable.setLayout(new GridLayout(1, 1, 5, 5));
            panTable.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Results"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            Object[][] colData = new String[1][4];
            colData[0][0] = new String();
            colData[0][1] = new String();
            colData[0][2] = new String();
            colData[0][3] = new String();
            this.outTable = new JTable(colData, this.colNames);
            panTable.add(new JScrollPane(this.outTable));
            this.add((Component)panTable, SPIProtocolAnalysis.createConstraints(1, 0, 3, 3, 1.0, 1.0));
            JButton convert = new JButton("Analyze");
            convert.addActionListener(this);
            this.add((Component)convert, SPIProtocolAnalysis.createConstraints(0, 3, 1, 1, 0.5, 0.0));
            JButton export = new JButton("Export");
            export.addActionListener(this);
            this.add((Component)export, SPIProtocolAnalysis.createConstraints(1, 3, 1, 1, 0.5, 0.0));
            JButton cancel = new JButton("Close");
            cancel.addActionListener(this);
            this.add((Component)cancel, SPIProtocolAnalysis.createConstraints(2, 3, 1, 1, 0.5, 0.0));
            this.fileChooser = new JFileChooser();
            this.fileChooser.addChoosableFileFilter(new CSVFilter());
            this.pack();
            this.setResizable(false);
        }

        public void showDialog(CapturedData data) {
            this.analysisData = data;
            if (this.analysisData.hasTimingData()) {
                float step = 1 / this.analysisData.rate;
                this.unitFactor = 1L;
                this.unitName = "s";
                if ((double)step <= 1.0E-6) {
                    this.unitFactor = 1000000000L;
                    this.unitName = "ns";
                } else if ((double)step <= 0.001) {
                    this.unitFactor = 1000000L;
                    this.unitName = "\u00b5s";
                } else if (step <= 1.0f) {
                    this.unitFactor = 1000L;
                    this.unitName = "ms";
                }
            } else {
                this.unitFactor = 1L;
                this.unitName = "";
            }
            this.setVisible(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Analyze")) {
                this.decode();
            } else if (e.getActionCommand().equals("Close")) {
                this.setVisible(false);
            } else if (e.getActionCommand().equals("Export") && this.fileChooser.showSaveDialog(this) == 0) {
                File file = this.fileChooser.getSelectedFile();
                this.storeToFile(file);
            }
        }

        private void decode() {
            this.decodedData.clear();
            int csmask = 1 << this.cs.getSelectedIndex();
            int sckmask = 1 << this.sck.getSelectedIndex();
            int misomask = 1 << this.miso.getSelectedIndex();
            int mosimask = 1 << this.mosi.getSelectedIndex();
            System.out.println("csmask   = 0x" + Integer.toHexString(csmask));
            System.out.println("sckmask  = 0x" + Integer.toHexString(sckmask));
            System.out.println("misomask = 0x" + Integer.toHexString(misomask));
            System.out.println("mosimask = 0x" + Integer.toHexString(mosimask));
            int a = this.analysisData.values[0] & csmask;
            int c = 0;
            int b = 0;
            int i = 0;
            while (i < this.analysisData.values.length) {
                if (a > (this.analysisData.values[i] & csmask)) {
                    b = i;
                    c = 1;
                    System.out.println("CS found at " + i);
                    break;
                }
                a = this.analysisData.values[i] & csmask;
                ++i;
            }
            if (c == 0 && this.analysisData.hasTriggerData()) {
                b = this.analysisData.triggerPosition;
            }
            this.decodedData.addElement(new SPIProtocolAnalysisDataSet(b, "CSLOW"));
            this.startOfDecode = b;
            if (this.mode.getSelectedItem().equals("0") || this.mode.getSelectedItem().equals("2")) {
                int bitCount;
                c = this.analysisData.values[b] & sckmask;
                a = this.analysisData.values[b] & csmask;
                int maxbits = bitCount = Integer.parseInt((String)this.bits.getSelectedItem()) - 1;
                int misovalue = 0;
                int mosivalue = 0;
                i = b;
                while (i < this.analysisData.values.length) {
                    if (c < (this.analysisData.values[i] & sckmask)) {
                        if (this.order.getSelectedItem().equals("MSB first")) {
                            if ((this.analysisData.values[i] & misomask) == misomask) {
                                misovalue |= 1 << bitCount;
                            }
                            if ((this.analysisData.values[i] & mosimask) == mosimask) {
                                mosivalue |= 1 << bitCount;
                            }
                        } else {
                            if ((this.analysisData.values[i] & misomask) == misomask) {
                                misovalue |= 1 << maxbits - bitCount;
                            }
                            if ((this.analysisData.values[i] & mosimask) == mosimask) {
                                mosivalue |= 1 << maxbits - bitCount;
                            }
                        }
                        if (bitCount > 0) {
                            --bitCount;
                        } else {
                            this.decodedData.addElement(new SPIProtocolAnalysisDataSet(i, mosivalue, misovalue));
                            System.out.println("MISO = 0x" + Integer.toHexString(misovalue));
                            System.out.println("MOSI = 0x" + Integer.toHexString(mosivalue));
                            bitCount = Integer.parseInt((String)this.bits.getSelectedItem()) - 1;
                            misovalue = 0;
                            mosivalue = 0;
                            if (a > (this.analysisData.values[i] & csmask)) {
                                this.decodedData.addElement(new SPIProtocolAnalysisDataSet(i, "CSLOW"));
                            } else if (a < (this.analysisData.values[i] & csmask)) {
                                this.decodedData.addElement(new SPIProtocolAnalysisDataSet(i, "CSHIGH"));
                            }
                            a = this.analysisData.values[i] & csmask;
                        }
                    }
                    c = this.analysisData.values[i] & sckmask;
                    ++i;
                }
            } else {
                int bitCount;
                c = this.analysisData.values[b] & sckmask;
                a = this.analysisData.values[b] & csmask;
                int maxbits = bitCount = Integer.parseInt((String)this.bits.getSelectedItem()) - 1;
                int misovalue = 0;
                int mosivalue = 0;
                i = b;
                while (i < this.analysisData.values.length) {
                    if (c > (this.analysisData.values[i] & sckmask)) {
                        if (this.order.getSelectedItem().equals("MSB first")) {
                            if ((this.analysisData.values[i] & misomask) == misomask) {
                                misovalue |= 1 << bitCount;
                            }
                            if ((this.analysisData.values[i] & mosimask) == mosimask) {
                                mosivalue |= 1 << bitCount;
                            }
                        } else {
                            if ((this.analysisData.values[i] & misomask) == misomask) {
                                misovalue |= 1 << maxbits - bitCount;
                            }
                            if ((this.analysisData.values[i] & mosimask) == mosimask) {
                                mosivalue |= 1 << maxbits - bitCount;
                            }
                        }
                        if (bitCount > 0) {
                            --bitCount;
                        } else {
                            this.decodedData.addElement(new SPIProtocolAnalysisDataSet(i, mosivalue, misovalue));
                            System.out.println("MISO = 0x" + Integer.toHexString(misovalue));
                            System.out.println("MOSI = 0x" + Integer.toHexString(mosivalue));
                            bitCount = Integer.parseInt((String)this.bits.getSelectedItem()) - 1;
                            misovalue = 0;
                            mosivalue = 0;
                            if (a > (this.analysisData.values[i] & csmask)) {
                                this.decodedData.addElement(new SPIProtocolAnalysisDataSet(i, "CSLOW"));
                            } else if (a < (this.analysisData.values[i] & csmask)) {
                                this.decodedData.addElement(new SPIProtocolAnalysisDataSet(i, "CSHIGH"));
                            }
                            a = this.analysisData.values[i] & csmask;
                        }
                    }
                    c = this.analysisData.values[i] & sckmask;
                    ++i;
                }
            }
            this.outTable.setModel(this.toTableData());
        }

        private void storeToFile(File file) {
            System.out.println("writing decoded data to " + file.getPath());
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                int i = 0;
                while (i < this.outTable.getRowCount()) {
                    bw.write("\"" + (String)this.outTable.getValueAt(i, 0) + "\",\"" + (String)this.outTable.getValueAt(i, 1) + "\",\"" + (String)this.outTable.getValueAt(i, 2) + "\",\"" + (String)this.outTable.getValueAt(i, 3) + "\"");
                    bw.newLine();
                    ++i;
                }
                bw.close();
            }
            catch (Exception E) {
                E.printStackTrace(System.out);
            }
        }

        private String indexToTime(int count) {
            return String.valueOf((long)(count - this.startOfDecode) * this.unitFactor / (long)this.analysisData.rate) + this.unitName;
        }

        private DefaultTableModel toTableData() {
            Object[][] data = new String[this.decodedData.size()][4];
            int i = 0;
            while (i < this.decodedData.size()) {
                SPIProtocolAnalysisDataSet ds = (SPIProtocolAnalysisDataSet)this.decodedData.get(i);
                if (ds.isEvent()) {
                    data[i][0] = new String("" + (i + 1));
                    data[i][1] = new String(this.indexToTime(ds.time));
                    data[i][2] = new String(ds.event);
                    data[i][3] = new String(ds.event);
                } else {
                    data[i][0] = new String("" + (i + 1));
                    data[i][1] = new String(this.indexToTime(ds.time));
                    data[i][2] = new String("0x" + Integer.toHexString(ds.mosi) + "," + ds.mosi);
                    data[i][3] = new String("0x" + Integer.toHexString(ds.miso) + "," + ds.miso);
                }
                ++i;
            }
            DefaultTableModel mod = new DefaultTableModel(data, this.colNames);
            return mod;
        }

        public void readProperties(Properties properties) {
            SPIProtocolAnalysis.this.selectByIndex(this.sck, properties.getProperty("tools.SPIProtocolAnalysis.sck"));
            SPIProtocolAnalysis.this.selectByIndex(this.miso, properties.getProperty("tools.SPIProtocolAnalysis.miso"));
            SPIProtocolAnalysis.this.selectByIndex(this.mosi, properties.getProperty("tools.SPIProtocolAnalysis.mosi"));
            SPIProtocolAnalysis.this.selectByIndex(this.cs, properties.getProperty("tools.SPIProtocolAnalysis.cs"));
            SPIProtocolAnalysis.this.selectByValue(this.mode, this.modearray, properties.getProperty("tools.SPIProtocolAnalysis.mode"));
            SPIProtocolAnalysis.this.selectByValue(this.bits, this.bitarray, properties.getProperty("tools.SPIProtocolAnalysis.bits"));
            SPIProtocolAnalysis.this.selectByValue(this.order, this.orderarray, properties.getProperty("tools.SPIProtocolAnalysis.order"));
        }

        public void writeProperties(Properties properties) {
            properties.setProperty("tools.SPIProtocolAnalysis.sck", Integer.toString(this.sck.getSelectedIndex()));
            properties.setProperty("tools.SPIProtocolAnalysis.miso", Integer.toString(this.miso.getSelectedIndex()));
            properties.setProperty("tools.SPIProtocolAnalysis.mosi", Integer.toString(this.mosi.getSelectedIndex()));
            properties.setProperty("tools.SPIProtocolAnalysis.cs", Integer.toString(this.cs.getSelectedIndex()));
            properties.setProperty("tools.SPIProtocolAnalysis.mode", (String)this.mode.getSelectedItem());
            properties.setProperty("tools.SPIProtocolAnalysis.bits", (String)this.bits.getSelectedItem());
            properties.setProperty("tools.SPIProtocolAnalysis.order", (String)this.order.getSelectedItem());
        }
    }

    private class CSVFilter
    extends FileFilter {
        private CSVFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".csv");
        }

        public String getDescription() {
            return "Character sepatated Values (*.csv)";
        }
    }
}

