/*
 * Decompiled with CFR 0.152.
 */
package org.sump.analyzer.tools;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import org.sump.analyzer.CapturedData;
import org.sump.analyzer.Configurable;
import org.sump.analyzer.tools.Base;
import org.sump.analyzer.tools.Tool;
import org.sump.util.Properties;

public class I2CProtocolAnalysis
extends Base
implements Tool,
Configurable {
    private I2CProtocolAnalysisDialog spad;

    private static GridBagConstraints createConstraints(int x, int y, int w, int h, double wx, double wy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = wx;
        gbc.weighty = wy;
        return gbc;
    }

    public void init(Frame frame) {
        this.spad = new I2CProtocolAnalysisDialog(frame, this.getName());
    }

    public String getName() {
        return "I2C Protocol Analysis...";
    }

    public CapturedData process(CapturedData data) {
        this.spad.showDialog(data);
        return null;
    }

    public void readProperties(Properties properties) {
        this.spad.readProperties(properties);
    }

    public void writeProperties(Properties properties) {
        this.spad.writeProperties(properties);
    }

    private class I2CProtocolAnalysisDataSet {
        public int time;
        public int value;
        public String event;

        public I2CProtocolAnalysisDataSet(int tm, int val) {
            this.time = tm;
            this.value = val;
            this.event = null;
        }

        public I2CProtocolAnalysisDataSet(int tm, String ev) {
            this.time = tm;
            this.value = 0;
            this.event = new String(ev);
        }

        public boolean isEvent() {
            return this.event != null;
        }
    }

    private class I2CProtocolAnalysisDialog
    extends JDialog
    implements ActionListener {
        private JComboBox lineA;
        private JComboBox lineB;
        private CapturedData analysisData;
        private JEditorPane outText;
        private Vector decodedData;
        private JFileChooser fileChooser;
        private int startOfDecode;
        private JLabel busSetSCL;
        private JLabel busSetSDA;
        private JCheckBox detectSTART;
        private JCheckBox detectSTOP;
        private JCheckBox detectACK;
        private JCheckBox detectNACK;
        private int statDecodedBytes;
        private int statBusErrorCount;
        private static final long serialVersionUID = 1L;

        public I2CProtocolAnalysisDialog(Frame frame, String name) {
            super(frame, name, true);
            this.setLayout(new GridBagLayout());
            this.getRootPane().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.decodedData = new Vector();
            this.startOfDecode = 0;
            JPanel panSettings = new JPanel();
            panSettings.setLayout(new GridLayout(6, 2, 5, 5));
            panSettings.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Settings"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            String[] channels = new String[32];
            int i = 0;
            while (i < 32) {
                channels[i] = new String("Channel " + i);
                ++i;
            }
            panSettings.add(new JLabel("Line A"));
            this.lineA = new JComboBox<String>(channels);
            panSettings.add(this.lineA);
            panSettings.add(new JLabel("Line B"));
            this.lineB = new JComboBox<String>(channels);
            panSettings.add(this.lineB);
            this.detectSTART = new JCheckBox("Show START", true);
            panSettings.add(this.detectSTART);
            panSettings.add(new JLabel(""));
            this.detectSTOP = new JCheckBox("Show STOP", true);
            panSettings.add(this.detectSTOP);
            panSettings.add(new JLabel(""));
            this.detectACK = new JCheckBox("Show ACK", true);
            panSettings.add(this.detectACK);
            panSettings.add(new JLabel(""));
            this.detectNACK = new JCheckBox("Show NACK", true);
            panSettings.add(this.detectNACK);
            panSettings.add(new JLabel(""));
            this.add((Component)panSettings, I2CProtocolAnalysis.createConstraints(0, 0, 1, 1, 0.0, 0.0));
            JPanel panBusConfig = new JPanel();
            panBusConfig.setLayout(new GridLayout(2, 2, 5, 5));
            panBusConfig.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Bus Configuration"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            panBusConfig.add(new JLabel("SCL :"));
            this.busSetSCL = new JLabel("<autodetect>");
            panBusConfig.add(this.busSetSCL);
            panBusConfig.add(new JLabel("SDA :"));
            this.busSetSDA = new JLabel("<autodetect>");
            panBusConfig.add(this.busSetSDA);
            this.add((Component)panBusConfig, I2CProtocolAnalysis.createConstraints(0, 1, 1, 1, 0.0, 0.0));
            JPanel panTable = new JPanel();
            panTable.setLayout(new GridLayout(1, 1, 5, 5));
            panTable.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Results"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.outText = new JEditorPane("text/html", this.toHtmlPage(true));
            this.outText.setMargin(new Insets(5, 5, 5, 5));
            panTable.add(new JScrollPane(this.outText));
            this.add((Component)panTable, I2CProtocolAnalysis.createConstraints(1, 0, 3, 3, 1.0, 1.0));
            JPanel panButton = new JPanel();
            JButton convert = new JButton("Analyze");
            convert.addActionListener(this);
            panButton.add(convert);
            JButton export = new JButton("Export");
            export.addActionListener(this);
            panButton.add(export);
            JButton cancel = new JButton("Close");
            cancel.addActionListener(this);
            panButton.add(cancel);
            this.add((Component)panButton, I2CProtocolAnalysis.createConstraints(3, 3, 1, 1, 0.0, 0.0));
            this.fileChooser = new JFileChooser();
            this.fileChooser.addChoosableFileFilter(new CSVFilter());
            this.fileChooser.addChoosableFileFilter(new HTMLFilter());
            this.setSize(900, 500);
            this.setResizable(false);
        }

        public void showDialog(CapturedData data) {
            this.analysisData = data;
            this.setVisible(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Analyze")) {
                this.decode();
            } else if (e.getActionCommand().equals("Close")) {
                this.setVisible(false);
            } else if (e.getActionCommand().equals("Export") && this.fileChooser.showSaveDialog(this) == 0) {
                File file = this.fileChooser.getSelectedFile();
                if (this.fileChooser.getFileFilter().getDescription().equals("Website (*.html)")) {
                    this.storeToHtmlFile(file);
                } else {
                    this.storeToCsvFile(file);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private void decode() {
            this.decodedData.clear();
            sdaMask = 0;
            sclMask = 0;
            this.statBusErrorCount = 0;
            this.statDecodedBytes = 0;
            lineAmask = 1 << this.lineA.getSelectedIndex();
            lineBmask = 1 << this.lineB.getSelectedIndex();
            System.out.println("lineAmask = 0x" + Integer.toHexString(lineAmask));
            System.out.println("lineBmask = 0x" + Integer.toHexString(lineBmask));
            a = 0;
            while (a < this.analysisData.values.length) {
                if ((this.analysisData.values[a] & (lineAmask | lineBmask)) == (lineAmask | lineBmask)) break;
                ++a;
            }
            if (a != this.analysisData.values.length) ** GOTO lbl30
            return;
lbl-1000:
            // 1 sources

            {
                if ((this.analysisData.values[a] & (lineAmask | lineBmask)) != (lineAmask | lineBmask) && (this.analysisData.values[a] & (lineAmask | lineBmask)) != 0) {
                    if ((this.analysisData.values[a] & lineAmask) == 0) {
                        sdaMask = lineAmask;
                        sclMask = lineBmask;
                        this.busSetSCL.setText((String)this.lineB.getSelectedItem());
                        this.busSetSDA.setText((String)this.lineA.getSelectedItem());
                        break;
                    }
                    sdaMask = lineBmask;
                    sclMask = lineAmask;
                    this.busSetSCL.setText((String)this.lineA.getSelectedItem());
                    this.busSetSDA.setText((String)this.lineB.getSelectedItem());
                    break;
                }
                ++a;
lbl30:
                // 2 sources

                ** while (a < this.analysisData.values.length)
            }
lbl31:
            // 3 sources

            if (a == this.analysisData.values.length) {
                return;
            }
            if (this.detectSTART.isSelected()) {
                this.decodedData.addElement(new I2CProtocolAnalysisDataSet(a, "START"));
            }
            this.startOfDecode = a;
            b = this.analysisData.values[a] & sclMask;
            c = this.analysisData.values[a] & sdaMask;
            d = 8;
            sdaValue = 0;
            while (a < this.analysisData.values.length - 1) {
                if ((this.analysisData.values[++a] & sclMask) > b) {
                    if ((this.analysisData.values[a] & sdaMask) != c) {
                        this.decodedData.addElement(new I2CProtocolAnalysisDataSet(a, "BUS-ERROR"));
                        ++this.statBusErrorCount;
                    } else if (d == 0) {
                        if ((this.analysisData.values[a] & sdaMask) != 0) {
                            if (this.detectNACK.isSelected()) {
                                this.decodedData.addElement(new I2CProtocolAnalysisDataSet(a, "NACK"));
                            }
                        } else if (this.detectACK.isSelected()) {
                            this.decodedData.addElement(new I2CProtocolAnalysisDataSet(a, "ACK"));
                        }
                        d = 8;
                    } else {
                        --d;
                        if ((this.analysisData.values[a] & sdaMask) != 0) {
                            sdaValue |= 1 << d;
                        }
                        if (d == 0) {
                            this.decodedData.addElement(new I2CProtocolAnalysisDataSet(a, sdaValue));
                            sdaValue = 0;
                            ++this.statDecodedBytes;
                        }
                    }
                }
                if ((this.analysisData.values[a] & sclMask) == sclMask && (this.analysisData.values[a] & sdaMask) != c) {
                    if (d < 7) {
                        this.decodedData.addElement(new I2CProtocolAnalysisDataSet(a, "BUS-ERROR"));
                        ++this.statBusErrorCount;
                    } else {
                        if ((this.analysisData.values[a] & sdaMask) > c) {
                            if (this.detectSTOP.isSelected()) {
                                this.decodedData.addElement(new I2CProtocolAnalysisDataSet(a, "STOP"));
                            }
                        } else if (this.detectSTART.isSelected()) {
                            this.decodedData.addElement(new I2CProtocolAnalysisDataSet(a, "START"));
                        }
                        d = 8;
                    }
                }
                b = this.analysisData.values[a] & sclMask;
                c = this.analysisData.values[a] & sdaMask;
            }
            this.outText.setText(this.toHtmlPage(false));
            this.outText.setEditable(false);
        }

        private String toHtmlPage(boolean empty) {
            String header = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\"><html>  <head>    <title></title>    <meta content=\"\">    <style>\t\t\tth { text-align:left;font-style:italic;font-weight:bold;font-size:medium;font-family:sans-serif;background-color:#C0C0FF; }\t\t</style>  </head>\t<body>\t\t<H2>I2C Analysis Results</H2>\t\t<hr>\t\t\t<div style=\"text-align:right;font-size:x-small;\">07.02.2007, iec_dat.sla</div>\t\t<br>";
            String stats = "<table style=\"width:100%;\">";
            stats = empty ? String.valueOf(stats) + "<TR><TD style=\"width:30%;\">Decoded Bytes</TD><TD>-</TD></TR><TR><TD style=\"width:30%;\">Detected Bus Errors</TD><TD>-</TD></TR>" : String.valueOf(stats) + "<TR><TD style=\"width:30%;\">Decoded Bytes</TD><TD>" + this.statDecodedBytes + "</TD></TR>" + "<TR><TD style=\"width:30%;\">Detected Bus Errors</TD><TD>" + this.statBusErrorCount + "</TD></TR>";
            stats = String.valueOf(stats) + "</table><br><br>";
            String data = "<table style=\"font-family:monospace;width:100%;\"><tr><th style=\"width:15%;\">Index</th><th style=\"width:15%;\">Time</th><th style=\"width:20%;\">Hex</th><th style=\"width:20%;\">Bin</th><th style=\"width:20%;\">Dec</th><th style=\"width:10%;\">ASCII</th></tr>";
            if (!empty) {
                int i = 0;
                while (i < this.decodedData.size()) {
                    I2CProtocolAnalysisDataSet ds = (I2CProtocolAnalysisDataSet)this.decodedData.get(i);
                    if (ds.isEvent()) {
                        data = ds.event.equals("START") ? String.valueOf(data) + "<tr style=\"background-color:#E0E0E0;\"><td>" + i + "</td><td>" + this.indexToTime(ds.time) + "</td><td>START</td><td></td><td></td><td></td></tr>" : (ds.event.equals("STOP") ? String.valueOf(data) + "<tr style=\"background-color:#E0E0E0;\"><td>" + i + "</td><td>" + this.indexToTime(ds.time) + "</td><td>STOP</td><td></td><td></td><td></td></tr>" : (ds.event.equals("ACK") ? String.valueOf(data) + "<tr style=\"background-color:#C0FFC0;\"><td>" + i + "</td><td>" + this.indexToTime(ds.time) + "</td><td>ACK</td><td></td><td></td><td></td></tr>" : (ds.event.equals("NACK") ? String.valueOf(data) + "<tr style=\"background-color:#FFC0C0;\"><td>" + i + "</td><td>" + this.indexToTime(ds.time) + "</td><td>NACK</td><td></td><td></td><td></td></tr>" : (ds.event.equals("BUS-ERROR") ? String.valueOf(data) + "<tr style=\"background-color:#FF8000;\"><td>" + i + "</td><td>" + this.indexToTime(ds.time) + "</td><td>BUS-ERROR</td><td></td><td></td><td></td></tr>" : String.valueOf(data) + "<tr style=\"background-color:#FF8000;\"><td>" + i + "</td><td>" + this.indexToTime(ds.time) + "</td><td>UNKNOWN</td><td></td><td></td><td></td></tr>"))));
                    } else {
                        data = String.valueOf(data) + "<tr style=\"background-color:#FFFFFF;\"><td>" + i + "</td><td>" + this.indexToTime(ds.time) + "</td><td>" + "0x" + this.integerToHexString(ds.value, 2) + "</td><td>" + "0b" + this.integerToBinString(ds.value, 8) + "</td><td>" + ds.value + "</td><td>";
                        if (ds.value >= 32) {
                            data = String.valueOf(data) + (char)ds.value;
                        }
                        data = String.valueOf(data) + "</td></tr>";
                    }
                    ++i;
                }
            }
            data = String.valueOf(data) + "</table";
            String footer = "\t</body></html>";
            return String.valueOf(header) + stats + data + footer;
        }

        private void storeToCsvFile(File file) {
            if (this.decodedData.size() > 0) {
                System.out.println("writing decoded data to " + file.getPath());
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                    int i = 0;
                    while (i < this.decodedData.size()) {
                        I2CProtocolAnalysisDataSet dSet = (I2CProtocolAnalysisDataSet)this.decodedData.get(i);
                        if (dSet.isEvent()) {
                            bw.write("\"" + i + "\",\"" + this.indexToTime(dSet.time) + "\",\"" + dSet.event + "\"");
                        } else {
                            bw.write("\"" + i + "\",\"" + this.indexToTime(dSet.time) + "\",\"" + dSet.value + "\"");
                        }
                        bw.newLine();
                        ++i;
                    }
                    bw.close();
                }
                catch (Exception E) {
                    E.printStackTrace(System.out);
                }
            }
        }

        private void storeToHtmlFile(File file) {
            if (this.decodedData.size() > 0) {
                System.out.println("writing decoded data to " + file.getPath());
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                    bw.write(this.outText.getText());
                    bw.close();
                }
                catch (Exception E) {
                    E.printStackTrace(System.out);
                }
            }
        }

        private String indexToTime(int count) {
            if ((count -= this.startOfDecode) < 0) {
                count = 0;
            }
            if (this.analysisData.hasTimingData()) {
                float time = (float)((double)count * (1.0 / (double)this.analysisData.rate));
                if ((double)time < 1.0E-6) {
                    return String.valueOf(Math.rint((double)time * 1.0E9 * 100.0) / 100.0) + "ns";
                }
                if ((double)time < 0.001) {
                    return String.valueOf(Math.rint((double)time * 1000000.0 * 100.0) / 100.0) + "\u00b5s";
                }
                if ((double)time < 1.0) {
                    return String.valueOf(Math.rint((double)time * 1000.0 * 100.0) / 100.0) + "ms";
                }
                return String.valueOf(Math.rint(time * 100.0f) / 100.0) + "s";
            }
            return "" + count;
        }

        public void readProperties(Properties properties) {
            I2CProtocolAnalysis.this.selectByIndex(this.lineA, properties.getProperty("tools.I2CProtocolAnalysis.lineA"));
            I2CProtocolAnalysis.this.selectByIndex(this.lineB, properties.getProperty("tools.I2CProtocolAnalysis.lineB"));
        }

        public void writeProperties(Properties properties) {
            properties.setProperty("tools.I2CProtocolAnalysis.lineA", Integer.toString(this.lineA.getSelectedIndex()));
            properties.setProperty("tools.I2CProtocolAnalysis.lineB", Integer.toString(this.lineB.getSelectedIndex()));
        }

        private String integerToHexString(int val, int fieldWidth) {
            String str;
            int numberOfLeadingZeros;
            int mask = (int)Math.pow(16.0, fieldWidth);
            if ((numberOfLeadingZeros = fieldWidth - (str = Integer.toHexString(val & --mask)).length()) < 0) {
                numberOfLeadingZeros = 0;
            }
            if (numberOfLeadingZeros > fieldWidth) {
                numberOfLeadingZeros = fieldWidth;
            }
            char[] zeros = new char[numberOfLeadingZeros];
            int i = 0;
            while (i < zeros.length) {
                zeros[i] = 48;
                ++i;
            }
            String ldz = new String(zeros);
            return new String(String.valueOf(ldz) + str);
        }

        private String integerToBinString(int val, int fieldWidth) {
            String str;
            int numberOfLeadingZeros;
            int mask = (int)Math.pow(16.0, fieldWidth / 8);
            if ((numberOfLeadingZeros = fieldWidth - (str = Integer.toBinaryString(val & --mask)).length()) < 0) {
                numberOfLeadingZeros = 0;
            }
            if (numberOfLeadingZeros > fieldWidth) {
                numberOfLeadingZeros = fieldWidth;
            }
            char[] zeros = new char[numberOfLeadingZeros];
            int i = 0;
            while (i < zeros.length) {
                zeros[i] = 48;
                ++i;
            }
            String ldz = new String(zeros);
            return new String(String.valueOf(ldz) + str);
        }
    }

    private class CSVFilter
    extends FileFilter {
        private CSVFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".csv");
        }

        public String getDescription() {
            return "Character sepatated Values (*.csv)";
        }
    }

    private class HTMLFilter
    extends FileFilter {
        private HTMLFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".html");
        }

        public String getDescription() {
            return "Website (*.html)";
        }
    }
}

