/*
 * Decompiled with CFR 0.152.
 */
package org.sump.analyzer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import org.sump.analyzer.CapturedData;
import org.sump.analyzer.Configurable;
import org.sump.analyzer.DeviceController;
import org.sump.analyzer.Diagram;
import org.sump.analyzer.Project;
import org.sump.analyzer.StatusChangeListener;
import org.sump.analyzer.tools.Tool;

public final class MainWindow
extends WindowAdapter
implements Runnable,
ActionListener,
WindowListener,
StatusChangeListener {
    private JMenu toolMenu;
    private JMenu diagramMenu;
    private JFileChooser fileChooser;
    private JFileChooser projectChooser;
    private DeviceController controller;
    private Diagram diagram;
    private Project project = new Project();
    private JLabel status;
    private Tool[] tools;
    private JFrame frame;
    static /* synthetic */ Class class$0;

    private JMenu createMenu(String name, String[] entries) {
        JMenu menu = new JMenu(name);
        int i = 0;
        while (i < entries.length) {
            if (!entries[i].equals("")) {
                JMenuItem item = new JMenuItem(entries[i]);
                item.addActionListener(this);
                menu.add(item);
            } else {
                menu.add(new JSeparator());
            }
            ++i;
        }
        return menu;
    }

    private void createTools(JToolBar tools, String[] files, String[] descriptions) {
        int i = 0;
        while (i < files.length) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.sump.analyzer.MainWindow");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            URL u = clazz.getResource("icons/" + files[i]);
            JButton b = new JButton(new ImageIcon(u, descriptions[i]));
            b.setMargin(new Insets(0, 0, 0, 0));
            b.addActionListener(this);
            tools.add(b);
            ++i;
        }
    }

    private void enableDataDependingFunctions(boolean enable) {
        this.diagramMenu.setEnabled(enable);
        this.toolMenu.setEnabled(enable);
    }

    void createGUI() {
        this.frame = new JFrame("Logic Analyzer Client");
        this.frame.setIconImage(new ImageIcon("org/sump/analyzer/icons/la.png").getImage());
        Container contentPane = this.frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JMenuBar mb = new JMenuBar();
        String[] fileEntries = new String[]{"Open...", "Save as...", "", "Exit"};
        JMenu fileMenu = this.createMenu("File", fileEntries);
        mb.add(fileMenu);
        String[] projectEntries = new String[]{"Open Project...", "Save Project as..."};
        JMenu projectMenu = this.createMenu("Project", projectEntries);
        mb.add(projectMenu);
        String[] deviceEntries = new String[]{"Capture...", "Repeat Capture"};
        JMenu deviceMenu = this.createMenu("Device", deviceEntries);
        mb.add(deviceMenu);
        String[] diagramEntries = new String[]{"Zoom In", "Zoom Out", "Default Zoom", "", "Diagram Settings...", "Labels..."};
        this.diagramMenu = this.createMenu("Diagram", diagramEntries);
        mb.add(this.diagramMenu);
        String[] toolClasses = new String[]{"org.sump.analyzer.tools.StateAnalysis", "org.sump.analyzer.tools.SPIProtocolAnalysis", "org.sump.analyzer.tools.I2CProtocolAnalysis"};
        LinkedList loadedTools = new LinkedList();
        int i = 0;
        while (i < toolClasses.length) {
            try {
                Class<?> tool = Class.forName(toolClasses[i]);
                Object o = tool.newInstance();
                if (o instanceof Tool) {
                    loadedTools.add(o);
                }
                if (o instanceof Configurable) {
                    this.project.addConfigurable((Configurable)o);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.tools = new Tool[loadedTools.size()];
        Iterator test = loadedTools.iterator();
        int i2 = 0;
        while (test.hasNext()) {
            this.tools[i2] = (Tool)test.next();
            ++i2;
        }
        String[] toolEntries = new String[this.tools.length];
        int i3 = 0;
        while (i3 < this.tools.length) {
            this.tools[i3].init(this.frame);
            toolEntries[i3] = this.tools[i3].getName();
            ++i3;
        }
        this.toolMenu = this.createMenu("Tools", toolEntries);
        mb.add(this.toolMenu);
        String[] helpEntries = new String[]{"About"};
        JMenu helpMenu = this.createMenu("Help", helpEntries);
        mb.add(helpMenu);
        this.frame.setJMenuBar(mb);
        JToolBar tools = new JToolBar();
        tools.setRollover(true);
        tools.setFloatable(false);
        String[] fileToolsF = new String[]{"fileopen.png", "filesaveas.png"};
        String[] fileToolsD = new String[]{"Open...", "Save as..."};
        this.createTools(tools, fileToolsF, fileToolsD);
        tools.addSeparator();
        String[] deviceToolsF = new String[]{"launch.png", "reload.png"};
        String[] deviceToolsD = new String[]{"Capture...", "Repeat Capture"};
        this.createTools(tools, deviceToolsF, deviceToolsD);
        tools.addSeparator();
        String[] diagramToolsF = new String[]{"viewmag+.png", "viewmag-.png", "viewmag1.png"};
        String[] diagramToolsD = new String[]{"Zoom In", "Zoom Out", "Default Zoom"};
        this.createTools(tools, diagramToolsF, diagramToolsD);
        contentPane.add((Component)tools, "North");
        this.status = new JLabel(" ");
        contentPane.add((Component)this.status, "South");
        this.diagram = new Diagram();
        this.project.addConfigurable(this.diagram);
        this.diagram.addStatusChangeListener(this);
        contentPane.add((Component)new JScrollPane(this.diagram), "Center");
        this.enableDataDependingFunctions(false);
        this.frame.setSize(1000, 835);
        this.frame.addWindowListener(this);
        this.frame.setVisible(true);
        this.fileChooser = new JFileChooser();
        this.fileChooser.addChoosableFileFilter(new SLAFilter());
        this.projectChooser = new JFileChooser();
        this.projectChooser.addChoosableFileFilter(new SLPFilter());
        this.controller = new DeviceController();
        this.project.addConfigurable(this.controller);
    }

    public void actionPerformed(ActionEvent event) {
        String label = event.getActionCommand();
        if (label.equals("") && event.getSource() instanceof JButton) {
            label = ((ImageIcon)((JButton)event.getSource()).getIcon()).getDescription();
        }
        System.out.println(label);
        try {
            if (label.equals("Open...")) {
                File file;
                if (this.fileChooser.showOpenDialog(this.frame) == 0 && (file = this.fileChooser.getSelectedFile()).isFile()) {
                    this.loadData(file);
                }
            } else if (label.equals("Save as...")) {
                if (this.fileChooser.showSaveDialog(this.frame) == 0) {
                    File file = this.fileChooser.getSelectedFile();
                    System.out.println("Saving: " + file.getName() + ".");
                    this.diagram.getCapturedData().writeToFile(file);
                }
            } else if (label.equals("Open Project...")) {
                File file;
                if (this.projectChooser.showOpenDialog(this.frame) == 0 && (file = this.projectChooser.getSelectedFile()).isFile()) {
                    this.loadProject(file);
                }
            } else if (label.equals("Save Project as...")) {
                if (this.projectChooser.showSaveDialog(this.frame) == 0) {
                    File file = this.projectChooser.getSelectedFile();
                    System.out.println("Saving Project: " + file.getName() + ".");
                    this.project.store(file);
                }
            } else if (label.equals("Capture...")) {
                if (this.controller.showCaptureDialog(this.frame) == 3) {
                    this.diagram.setCapturedData(this.controller.getDeviceData());
                }
            } else if (label.equals("Repeat Capture")) {
                if (this.controller.showCaptureProgress(this.frame) == 3) {
                    this.diagram.setCapturedData(this.controller.getDeviceData());
                }
            } else if (label.equals("Exit")) {
                this.exit();
            } else if (label.equals("Zoom In")) {
                this.diagram.zoomIn();
            } else if (label.equals("Zoom Out")) {
                this.diagram.zoomOut();
            } else if (label.equals("Default Zoom")) {
                this.diagram.zoomDefault();
            } else if (label.equals("Diagram Settings...")) {
                this.diagram.showSettingsDialog(this.frame);
            } else if (label.equals("Labels...")) {
                this.diagram.showLabelsDialog(this.frame);
            } else if (label.equals("About")) {
                JOptionPane.showMessageDialog(null, "Sump's Logic Analyzer Client\n\nCopyright 2006 Michael Poppitz\nThis software is released under the GNU GPL.\n\nFor more information see:\nhttp://www.sump.org/projects/analyzer/", "About", 1);
            } else {
                int i = 0;
                while (i < this.tools.length) {
                    CapturedData newData;
                    if (label.equals(this.tools[i].getName()) && (newData = this.tools[i].process(this.diagram.getCapturedData())) != null) {
                        this.diagram.setCapturedData(newData);
                    }
                    ++i;
                }
            }
            this.enableDataDependingFunctions(this.diagram.hasCapturedData());
        }
        catch (Exception E) {
            E.printStackTrace(System.out);
        }
    }

    public void statusChanged(String s) {
        this.status.setText(s);
    }

    public void windowClosing(WindowEvent event) {
        this.exit();
    }

    public void loadData(File file) throws IOException {
        System.out.println("Opening: " + file.getName());
        this.diagram.setCapturedData(new CapturedData(file));
    }

    public void loadProject(File file) throws IOException {
        System.out.println("Opening Project: " + file.getName());
        this.project.load(file);
    }

    public void run() {
        this.createGUI();
    }

    public void exit() {
        System.exit(0);
    }

    private class SLAFilter
    extends FileFilter {
        private SLAFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".sla");
        }

        public String getDescription() {
            return "Sump's Logic Analyzer Files (*.sla)";
        }
    }

    private class SLPFilter
    extends FileFilter {
        private SLPFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".slp");
        }

        public String getDescription() {
            return "Sump's Logic Analyzer Project Files (*.slp)";
        }
    }
}

