/*
 * Decompiled with CFR 0.152.
 */
package org.sump.analyzer;

import java.io.File;
import javax.swing.SwingUtilities;
import org.sump.analyzer.MainWindow;

public class Loader {
    public static void main(String[] args) {
        MainWindow w = new MainWindow();
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                System.out.println();
                System.out.println("Sumps Logic Analyzer Client");
                System.out.println("Copyright (C) 2006 Michael Poppitz");
                System.out.println("This software is released under the GNU GPL.");
                System.out.println();
                System.out.println("Usage: run [<project file>] [<data file>]");
                System.out.println();
                System.out.println("\t<project file> is a saved project with file extension \".slp\"");
                System.out.println("\t<data file> is saved data with file extension \".sla\"");
                System.out.println();
                System.exit(0);
            } else {
                try {
                    File f = new File(arg);
                    if (!f.isFile()) {
                        System.out.println("Error: File does not exist: " + arg);
                        System.exit(-1);
                    }
                    if (arg.toLowerCase().endsWith(".slp")) {
                        w.loadProject(f);
                    } else if (arg.toLowerCase().endsWith(".sla")) {
                        w.loadData(f);
                    } else {
                        System.out.println("Error: Unknown file type in argument: " + arg);
                        System.exit(-1);
                    }
                }
                catch (Exception e) {
                    System.out.println("Error: Exception occured while reading file: " + e.getMessage());
                    System.exit(-1);
                }
            }
            ++i;
        }
        try {
            SwingUtilities.invokeAndWait(w);
        }
        catch (Exception e) {
            System.out.println("Error while invoking application: " + e.getMessage() + "\n");
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

