/*
 * Decompiled with CFR 0.152.
 */
package org.sump.analyzer;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.sump.analyzer.Configurable;
import org.sump.util.Properties;

public class DiagramSettings
extends JComponent
implements ActionListener,
Configurable {
    public static final int CANCEL = 0;
    public static final int OK = 1;
    public static final int DISPLAY_CHANNELS = 1;
    public static final int DISPLAY_SCOPE = 2;
    public static final int DISPLAY_BYTE = 4;
    public int[] groupSettings;
    private JDialog dialog;
    private JCheckBox[][] groupSettingBoxes;
    private int result;

    private static GridBagConstraints createConstraints(int x, int y, int w, int h, double wx, double wy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = wx;
        gbc.weighty = wy;
        return gbc;
    }

    public DiagramSettings() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel modePane = new JPanel();
        modePane.setLayout(new GridBagLayout());
        modePane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Group Display Settings"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.groupSettingBoxes = new JCheckBox[4][3];
        int i = 0;
        while (i < 4) {
            modePane.add((Component)new JLabel("Group " + i + ": "), DiagramSettings.createConstraints(0, i, 1, 1, 0.0, 0.0));
            this.groupSettingBoxes[i][0] = new JCheckBox();
            modePane.add((Component)this.groupSettingBoxes[i][0], DiagramSettings.createConstraints(1, i, 1, 1, 0.0, 0.0));
            modePane.add((Component)new JLabel("Channels"), DiagramSettings.createConstraints(2, i, 1, 1, 0.0, 0.0));
            this.groupSettingBoxes[i][1] = new JCheckBox();
            modePane.add((Component)this.groupSettingBoxes[i][1], DiagramSettings.createConstraints(3, i, 1, 1, 0.0, 0.0));
            modePane.add((Component)new JLabel("Scope"), DiagramSettings.createConstraints(4, i, 1, 1, 0.0, 0.0));
            this.groupSettingBoxes[i][2] = new JCheckBox();
            modePane.add((Component)this.groupSettingBoxes[i][2], DiagramSettings.createConstraints(5, i, 1, 1, 0.0, 0.0));
            modePane.add((Component)new JLabel("Byte Value"), DiagramSettings.createConstraints(6, i, 1, 1, 0.0, 0.0));
            ++i;
        }
        this.add((Component)modePane, DiagramSettings.createConstraints(0, 0, 2, 1, 0.0, 0.0));
        JButton ok = new JButton("Ok");
        ok.addActionListener(this);
        this.add((Component)ok, DiagramSettings.createConstraints(0, 1, 1, 1, 0.5, 0.0));
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        this.add((Component)cancel, DiagramSettings.createConstraints(1, 1, 1, 1, 0.5, 0.0));
        this.groupSettings = new int[4];
        int i2 = 0;
        while (i2 < this.groupSettings.length) {
            this.groupSettings[i2] = 5;
            ++i2;
        }
    }

    private void initDialog(Frame frame) {
        if (this.dialog != null && this.dialog.getOwner() != frame) {
            this.dialog.dispose();
            this.dialog = null;
        }
        if (this.dialog == null) {
            this.dialog = new JDialog(frame, "Diagram Settings", true);
            this.dialog.getContentPane().add(this);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
    }

    private void updateFields() {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 3) {
                this.groupSettingBoxes[i][j].setSelected((this.groupSettings[i] & 1 << j) > 0);
                ++j;
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            int i = 0;
            while (i < 4) {
                this.groupSettings[i] = 0;
                int j = 0;
                while (j < 3) {
                    if (this.groupSettingBoxes[i][j].isSelected()) {
                        int n = i;
                        this.groupSettings[n] = this.groupSettings[n] | 1 << j;
                    }
                    ++j;
                }
                ++i;
            }
            this.result = 1;
        }
        this.dialog.setVisible(false);
    }

    public int showDialog(Frame frame) {
        this.initDialog(frame);
        this.updateFields();
        this.result = 0;
        this.dialog.setVisible(true);
        return this.result;
    }

    public void readProperties(Properties properties) {
        int i = 0;
        while (i < 4) {
            String value = properties.getProperty("DiagramSettings.group" + i);
            if (value != null) {
                this.groupSettings[i] = 0;
                if (value.indexOf("channels") >= 0) {
                    int n = i;
                    this.groupSettings[n] = this.groupSettings[n] | 1;
                }
                if (value.indexOf("scope") >= 0) {
                    int n = i;
                    this.groupSettings[n] = this.groupSettings[n] | 2;
                }
                if (value.indexOf("byte") >= 0) {
                    int n = i;
                    this.groupSettings[n] = this.groupSettings[n] | 4;
                }
            }
            ++i;
        }
        this.updateFields();
    }

    public void writeProperties(Properties properties) {
        int i = 0;
        while (i < 4) {
            StringBuffer value = new StringBuffer();
            if ((this.groupSettings[i] & 1) != 0) {
                value.append("channels ");
            }
            if ((this.groupSettings[i] & 2) != 0) {
                value.append("scope ");
            }
            if ((this.groupSettings[i] & 4) != 0) {
                value.append("byte ");
            }
            properties.setProperty("DiagramSettings.group" + i, value.toString());
            ++i;
        }
    }
}

