/*
 * Decompiled with CFR 0.152.
 */
package org.sump.analyzer;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.sump.analyzer.Configurable;
import org.sump.util.Properties;

public class DiagramLabels
extends JComponent
implements ActionListener,
Configurable {
    public static final int CANCEL = 0;
    public static final int OK = 1;
    public String[] diagramLabels;
    private JDialog dialog;
    private JTextField[] labelFields;
    private int result;

    private static GridBagConstraints createConstraints(int x, int y, int w, int h, double wx, double wy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = wx;
        gbc.weighty = wy;
        return gbc;
    }

    public DiagramLabels() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel modePane = new JPanel();
        modePane.setLayout(new GridBagLayout());
        modePane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Diagram Labels"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.labelFields = new JTextField[32];
        this.diagramLabels = new String[32];
        int col = 0;
        while (col < 2) {
            int row = 0;
            while (row < 16) {
                int num = 16 * col + row;
                modePane.add((Component)new JLabel("Channel " + num + ": "), DiagramLabels.createConstraints(2 * col, row, 1, 1, 0.0, 0.0));
                this.labelFields[num] = new JTextField(20);
                modePane.add((Component)this.labelFields[num], DiagramLabels.createConstraints(2 * col + 1, row, 1, 1, 0.0, 0.0));
                this.diagramLabels[num] = new String();
                ++row;
            }
            ++col;
        }
        this.add((Component)modePane, DiagramLabels.createConstraints(0, 0, 5, 1, 0.0, 0.0));
        JButton ok = new JButton("Ok");
        ok.addActionListener(this);
        this.add((Component)ok, DiagramLabels.createConstraints(0, 1, 1, 1, 0.34, 0.0));
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        this.add((Component)cancel, DiagramLabels.createConstraints(1, 1, 1, 1, 0.33, 0.0));
        JButton clear = new JButton("Clear");
        clear.addActionListener(this);
        this.add((Component)clear, DiagramLabels.createConstraints(2, 1, 1, 1, 0.33, 0.0));
    }

    private void initDialog(Frame frame) {
        if (this.dialog != null && this.dialog.getOwner() != frame) {
            this.dialog.dispose();
            this.dialog = null;
        }
        if (this.dialog == null) {
            this.dialog = new JDialog(frame, "Diagram Labels", true);
            this.dialog.getContentPane().add(this);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
    }

    private void updateFields() {
        int i = 0;
        while (i < 32) {
            this.labelFields[i].setText(this.diagramLabels[i]);
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            int i = 0;
            while (i < 32) {
                this.diagramLabels[i] = new String(this.labelFields[i].getText());
                ++i;
            }
            this.result = 1;
            this.dialog.setVisible(false);
        } else if (e.getActionCommand().equals("Clear")) {
            int i = 0;
            while (i < 32) {
                this.labelFields[i].setText("");
                ++i;
            }
        } else {
            this.dialog.setVisible(false);
        }
    }

    public int showDialog(Frame frame) {
        this.initDialog(frame);
        this.updateFields();
        this.result = 0;
        this.dialog.setVisible(true);
        return this.result;
    }

    public void readProperties(Properties properties) {
        int i = 0;
        while (i < 32) {
            if (properties.containsKey("DiagramLabels.channel" + i)) {
                this.diagramLabels[i] = properties.getProperty("DiagramLabels.channel" + i);
            }
            ++i;
        }
    }

    public void writeProperties(Properties properties) {
        int i = 0;
        while (i < 32) {
            properties.setProperty("DiagramLabels.channel" + i, this.diagramLabels[i]);
            ++i;
        }
    }
}

