/*
 * Decompiled with CFR 0.152.
 */
package org.sump.analyzer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import org.sump.analyzer.CapturedData;
import org.sump.analyzer.Configurable;
import org.sump.analyzer.DiagramLabels;
import org.sump.analyzer.DiagramSettings;
import org.sump.analyzer.StatusChangeListener;
import org.sump.util.Properties;

public class Diagram
extends JComponent
implements MouseMotionListener,
Configurable {
    private CapturedData capturedData;
    private DiagramSettings settings;
    private DiagramLabels labels;
    private long unitFactor;
    private String unitName;
    private int offsetX = 25;
    private int offsetY = 18;
    private int mouseX;
    private int mouseY;
    private int mouseDragX;
    private StatusChangeListener statusChangeListener;
    private double scale;
    private Color signal;
    private Color trigger;
    private Color grid;
    private Color text;
    private Color time;
    private Color groupBackground;
    private Color background;
    private Color label;
    private Dimension size = new Dimension(25, 1);
    private static final long serialVersionUID = 1L;

    public Diagram() {
        this.signal = new Color(0, 0, 196);
        this.trigger = new Color(196, 255, 196);
        this.grid = new Color(196, 196, 196);
        this.text = new Color(0, 0, 0);
        this.time = new Color(0, 0, 0);
        this.groupBackground = new Color(242, 242, 242);
        this.background = new Color(255, 255, 255);
        this.label = new Color(255, 196, 196);
        this.zoomDefault();
        this.setBackground(this.background);
        this.addMouseMotionListener(this);
        this.settings = new DiagramSettings();
        this.capturedData = null;
        this.labels = new DiagramLabels();
    }

    private void resize() {
        if (this.capturedData == null) {
            return;
        }
        int height = 20;
        int group = 0;
        while (group < this.capturedData.channels / 8 && group < 4) {
            if ((this.capturedData.enabledChannels >> 8 * group & 0xFF) != 0) {
                if ((this.settings.groupSettings[group] & 1) > 0) {
                    height += 160;
                }
                if ((this.settings.groupSettings[group] & 2) > 0) {
                    height += 133;
                }
                if ((this.settings.groupSettings[group] & 4) > 0) {
                    height += 20;
                }
            }
            ++group;
        }
        int width = (int)(25.0 + this.scale * (double)this.capturedData.values.length);
        Rectangle rect = this.getBounds();
        rect.setSize(width, height);
        this.setBounds(rect);
        this.size.width = width;
        this.size.height = height;
        this.update(this.getGraphics());
    }

    public void setCapturedData(CapturedData capturedData) {
        this.capturedData = capturedData;
        if (capturedData.hasTimingData()) {
            double step = 100.0 / this.scale / (double)capturedData.rate;
            this.unitFactor = 1L;
            this.unitName = "s";
            if (step <= 1.0E-6) {
                this.unitFactor = 1000000000L;
                this.unitName = "ns";
            } else if (step <= 0.001) {
                this.unitFactor = 1000000L;
                this.unitName = "\u00b5s";
            } else if (step <= 1.0) {
                this.unitFactor = 1000L;
                this.unitName = "ms";
            }
        } else {
            this.unitFactor = 1L;
            this.unitName = "";
        }
        this.resize();
    }

    public CapturedData getCapturedData() {
        return this.capturedData;
    }

    public boolean hasCapturedData() {
        return this.capturedData != null;
    }

    public void zoomIn() {
        if (this.scale < 10.0) {
            this.scale *= 2.0;
            this.resize();
        }
    }

    public void zoomOut() {
        this.scale /= 2.0;
        this.resize();
    }

    public void zoomDefault() {
        this.scale = 10.0;
        this.resize();
    }

    public void showSettingsDialog(Frame frame) {
        if (this.settings.showDialog(frame) == 1) {
            this.resize();
        }
    }

    public void showLabelsDialog(Frame frame) {
        if (this.labels.showDialog(frame) == 1) {
            this.resize();
        }
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public Dimension getMinimumSize() {
        return this.size;
    }

    private void drawEdge(Graphics g, int x, int y, boolean falling, boolean rising) {
        if (this.scale <= 1.0) {
            g.drawLine(x, y, x, y + 14);
        } else {
            int edgeX = x;
            if (this.scale >= 5.0) {
                edgeX += (int)(this.scale * 0.4);
            }
            if (rising) {
                g.drawLine(x, y + 14, edgeX, y);
                g.drawLine(edgeX, y, x + (int)this.scale, y);
            }
            if (falling) {
                g.drawLine(x, y, edgeX, y + 14);
                g.drawLine(edgeX, y + 14, x + (int)this.scale, y + 14);
            }
        }
    }

    private void drawChannel(Graphics g, int x, int y, int[] data, int n, int from, int to) {
        int current = from;
        while (current < to) {
            int currentV;
            int currentX = (int)((double)x + (double)current * this.scale);
            int nextV = currentV = data[current] >> n & 1;
            int next = current;
            do {
                nextV = data[++next] >> n & 1;
            } while (next < to && nextV == currentV);
            int currentEndX = currentX + (int)(this.scale * (double)(next - current - 1));
            if (currentV == nextV) {
                g.drawLine(currentX, y + 14 * (1 - currentV), currentEndX + (int)this.scale, y + 14 * (1 - currentV));
            } else {
                g.drawLine(currentX, y + 14 * (1 - currentV), currentEndX, y + 14 * (1 - currentV));
                if (currentV > nextV) {
                    this.drawEdge(g, currentEndX, y, true, false);
                } else if (currentV < nextV) {
                    this.drawEdge(g, currentEndX, y, false, true);
                }
            }
            current = next;
        }
    }

    private void drawGridLine(Graphics g, Rectangle clipArea, int y) {
        g.setColor(this.grid);
        g.drawLine(clipArea.x, y, clipArea.x + clipArea.width, y);
    }

    private int drawGroupByte(Graphics g, int x, int y, int[] data, Rectangle clipArea, int n, int from, int to) {
        g.setColor(this.groupBackground);
        g.fillRect(clipArea.x, y, clipArea.width, 19);
        g.setColor(this.text);
        g.drawString("B" + n, 5, y + 14);
        this.drawGridLine(g, clipArea, y + 19);
        g.setColor(this.signal);
        int yOfs = y + 2;
        int h = 14;
        int current = from;
        while (current < to) {
            int currentV;
            int currentX = (int)((double)x + (double)current * this.scale);
            int currentXSpace = (int)((double)x + (double)(current - 1) * this.scale);
            int nextV = currentV = data[current] >> 8 * n & 0xFF;
            int next = current;
            do {
                nextV = data[++next] >> 8 * n & 0xFF;
            } while (next < to && nextV == currentV);
            int currentEndX = currentX + (int)(this.scale * (double)(next - current - 1));
            if (currentV == nextV) {
                g.drawLine(currentX, yOfs + h, currentEndX + (int)this.scale, yOfs + h);
                g.drawLine(currentX, yOfs, currentEndX + (int)this.scale, yOfs);
            } else {
                g.drawLine(currentX, yOfs + h, currentEndX, yOfs + h);
                g.drawLine(currentX, yOfs, currentEndX, yOfs);
                this.drawEdge(g, currentEndX, yOfs, true, true);
            }
            if (currentEndX - currentXSpace > 15) {
                if (currentV >= 16) {
                    g.drawString(Integer.toString(currentV, 16), (currentXSpace + currentEndX) / 2 - 2, y + 14);
                } else {
                    g.drawString("0" + Integer.toString(currentV, 16), (currentXSpace + currentEndX) / 2 - 2, y + 14);
                }
            }
            current = next;
        }
        return 20;
    }

    private int drawGroupAnalyzer(Graphics g, int xofs, int yofs, int[] data, Rectangle clipArea, int n, int from, int to, String[] labels) {
        int bit = 0;
        while (bit < 8) {
            g.setColor(this.grid);
            g.drawLine(clipArea.x, 20 * bit + yofs + 19, clipArea.x + clipArea.width, 20 * bit + yofs + 19);
            g.setColor(this.text);
            g.drawString("" + (bit + n * 8), 5, 20 * bit + yofs + 14);
            g.setColor(this.label);
            if (labels[bit + n * 8] != null) {
                if (clipArea.x < xofs) {
                    g.drawString(labels[bit + n * 8], xofs, 20 * bit + yofs + 14);
                } else {
                    g.drawString(labels[bit + n * 8], clipArea.x, 20 * bit + yofs + 14);
                }
            }
            ++bit;
        }
        g.setColor(this.signal);
        bit = 0;
        while (bit < 8) {
            this.drawChannel(g, xofs, yofs + 20 * bit + 2, data, 8 * n + bit, from, to);
            ++bit;
        }
        return 160;
    }

    private int drawGroupScope(Graphics g, int x, int y, int[] data, Rectangle clipArea, int n, int from, int to) {
        g.setColor(this.text);
        g.drawString("S" + n, 5, y + 70);
        g.setColor(this.signal);
        int last = -1;
        int pos = from;
        while (pos < to) {
            int val = (255 - (data[pos] >> n * 8 & 0xFF)) / 2;
            if (last >= 0) {
                g.drawLine(x + (int)((double)(pos - 1) * this.scale), y + 2 + last, x + (int)((double)pos * this.scale), y + 2 + val);
            }
            last = val;
            ++pos;
        }
        this.drawGridLine(g, clipArea, y + 132);
        return 133;
    }

    public void paintComponent(Graphics g) {
        int lastRow;
        if (this.capturedData == null) {
            return;
        }
        int[] data = this.capturedData.values;
        boolean hasTiming = this.capturedData.hasTimingData();
        boolean hasTrigger = this.capturedData.hasTriggerData();
        int channels = this.capturedData.channels;
        int enabled = this.capturedData.enabledChannels;
        int triggerPosition = this.capturedData.triggerPosition;
        if (!hasTrigger) {
            triggerPosition = 0;
        }
        int rate = this.capturedData.rate;
        if (!hasTiming) {
            rate = 1;
        }
        int xofs = this.offsetX;
        int yofs = this.offsetY + 2;
        Rectangle clipArea = g.getClipBounds();
        int firstRow = this.xToIndex(clipArea.x);
        if (firstRow < 0) {
            firstRow = 0;
        }
        if ((lastRow = this.xToIndex(clipArea.x + clipArea.width) + 1) >= data.length) {
            lastRow = data.length - 1;
        }
        g.setColor(this.background);
        g.fillRect(clipArea.x, clipArea.y, clipArea.width, clipArea.height);
        if (hasTrigger && triggerPosition >= firstRow && triggerPosition <= lastRow) {
            g.setColor(this.trigger);
            g.fillRect(xofs + (int)((double)triggerPosition * this.scale) - 1, 0, (int)this.scale + 2, yofs + 720);
        }
        int rowInc = (int)(10.0 / this.scale);
        int timeLineShift = triggerPosition % rowInc;
        g.setColor(this.time);
        int row = firstRow / rowInc * rowInc + timeLineShift;
        while (row < lastRow) {
            int pos = (int)((double)xofs + this.scale * (double)row);
            if ((row - triggerPosition) / rowInc % 10 == 0) {
                g.drawLine(pos, 1, pos, 15);
                if (hasTiming) {
                    g.drawString(String.valueOf((float)Math.round((float)(10L * ((long)(row - triggerPosition) * this.unitFactor)) / (float)rate) / 10.0f) + this.unitName, pos + 5, 10);
                } else {
                    g.drawString(Long.toString(row - triggerPosition), pos + 5, 10);
                }
            } else {
                g.drawLine(pos, 12, pos, 15);
            }
            row += rowInc;
        }
        int bofs = yofs;
        this.drawGridLine(g, clipArea, bofs++);
        int block = 0;
        while (block < channels / 8) {
            if ((enabled >> 8 * block & 0xFF) != 0) {
                if (block < 4 && (this.settings.groupSettings[block] & 1) > 0) {
                    bofs += this.drawGroupAnalyzer(g, xofs, bofs, data, clipArea, block, firstRow, lastRow, this.labels.diagramLabels);
                }
                if (block < 4 && (this.settings.groupSettings[block] & 2) > 0) {
                    bofs += this.drawGroupScope(g, xofs, bofs, data, clipArea, block, firstRow, lastRow);
                }
                if (block < 4 && (this.settings.groupSettings[block] & 4) > 0) {
                    bofs += this.drawGroupByte(g, xofs, bofs, data, clipArea, block, firstRow, lastRow);
                }
            }
            ++block;
        }
    }

    private int xToIndex(int x) {
        int index = (int)((double)(x - this.offsetX) / this.scale);
        if (index < 0) {
            index = 0;
        }
        if (index >= this.capturedData.values.length) {
            index = this.capturedData.values.length - 1;
        }
        return index;
    }

    private String indexToTime(int count) {
        return String.valueOf((long)count * this.unitFactor / (long)this.capturedData.rate) + this.unitName;
    }

    private void updateStatus(boolean dragging) {
        if (this.capturedData == null || this.statusChangeListener == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(" ");
        int row = (this.mouseY - this.offsetY) / 20;
        if (row <= this.capturedData.channels + this.capturedData.channels / 9) {
            if (row % 9 == 8) {
                sb.append("Byte " + row / 9);
            } else {
                sb.append("Channel " + (row - row / 9));
            }
            sb.append(" | ");
        }
        if (dragging && this.xToIndex(this.mouseDragX) != this.xToIndex(this.mouseX)) {
            int index = this.xToIndex(this.mouseDragX);
            if (!this.capturedData.hasTimingData()) {
                sb.append("Sample " + (index - this.capturedData.triggerPosition));
                sb.append(" (Distance " + (index - this.xToIndex(this.mouseX)) + ")");
            } else {
                int div;
                String unit;
                float frequency = Math.abs(this.capturedData.rate / (index - this.xToIndex(this.mouseX)));
                if (frequency >= 1000000.0f) {
                    unit = "MHz";
                    div = 1000000;
                } else if (frequency >= 1000.0f) {
                    unit = "kHz";
                    div = 1000;
                } else {
                    unit = "Hz";
                    div = 1;
                }
                sb.append("Time " + this.indexToTime(index - this.capturedData.triggerPosition));
                sb.append(" (Duration " + this.indexToTime(index - this.xToIndex(this.mouseX)) + ", ");
                sb.append("Frequency " + frequency / (float)div + unit + ")");
            }
        } else if (!this.capturedData.hasTimingData()) {
            sb.append("Sample " + (this.xToIndex(this.mouseX) - this.capturedData.triggerPosition));
        } else {
            sb.append("Time " + this.indexToTime(this.xToIndex(this.mouseX) - this.capturedData.triggerPosition));
        }
        this.statusChangeListener.statusChanged(sb.toString());
    }

    public void mouseDragged(MouseEvent event) {
        this.mouseDragX = event.getX();
        this.updateStatus(true);
    }

    public void mouseMoved(MouseEvent event) {
        this.mouseX = event.getX();
        this.mouseY = event.getY();
        this.updateStatus(false);
    }

    public void addStatusChangeListener(StatusChangeListener listener) {
        this.statusChangeListener = listener;
    }

    public void readProperties(Properties properties) {
        this.settings.readProperties(properties);
        this.labels.readProperties(properties);
        this.resize();
    }

    public void writeProperties(Properties properties) {
        this.settings.writeProperties(properties);
        this.labels.writeProperties(properties);
    }
}

