/*
 * Decompiled with CFR 0.152.
 */
package org.sump.analyzer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import org.sump.analyzer.CapturedData;
import org.sump.analyzer.Configurable;
import org.sump.analyzer.Device;
import org.sump.util.Properties;

public class DeviceController
extends JComponent
implements ActionListener,
Runnable,
Configurable {
    public static final int IDLE = 0;
    public static final int RUNNING = 1;
    public static final int ABORTED = 2;
    public static final int DONE = 3;
    private Thread worker;
    private Timer timer;
    private JComboBox portSelect;
    private JComboBox portRateSelect;
    private JComboBox sourceSelect;
    private JComboBox speedSelect;
    private JComboBox sizeSelect;
    private JComboBox ratioSelect;
    private JCheckBox filterEnable;
    private JCheckBox triggerEnable;
    private JComboBox triggerTypeSelect;
    private JTabbedPane triggerStageTabs;
    private JComboBox[] triggerLevel;
    private JTextField[] triggerDelay;
    private JComboBox[] triggerMode;
    private JComboBox[] triggerChannel;
    private JCheckBox[] triggerStart;
    private JCheckBox[][] triggerMask;
    private JCheckBox[][] triggerValue;
    private JCheckBox[] channelGroup;
    private JProgressBar progress;
    private JButton captureButton;
    private JDialog dialog;
    private Device device;
    private CapturedData capturedData;
    private int triggerStages;
    private int status;
    private String errorMessage;
    private static final long serialVersionUID = 1L;
    private static final String NAME = "DeviceController";

    private JCheckBox[] createChannelList(JPanel pane, GridBagConstraints constraints) {
        JCheckBox[] boxes = new JCheckBox[32];
        Container container = new Container();
        container.setLayout(new GridLayout(1, 32));
        int col = 31;
        while (col >= 0) {
            JCheckBox box = new JCheckBox();
            box.setEnabled(false);
            container.add(box);
            if (col % 8 == 0 && col > 0) {
                container.add(new JLabel());
            }
            boxes[col] = box;
            --col;
        }
        pane.add((Component)container, constraints);
        return boxes;
    }

    private static GridBagConstraints createConstraints(int x, int y, int w, int h, double wx, double wy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = wx;
        gbc.weighty = wy;
        return gbc;
    }

    public DeviceController() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.device = new Device();
        JPanel connectionPane = new JPanel();
        connectionPane.setLayout(new GridLayout(2, 2, 5, 5));
        connectionPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Connection Settings"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        String[] ports = Device.getPorts();
        this.portSelect = new JComboBox<String>(ports);
        connectionPane.add(new JLabel("Analyzer Port:"));
        connectionPane.add(this.portSelect);
        String[] portRates = new String[]{"115200bps (LL)", "57600bps (LH)", "38400bps (HL)", "19200bps (HH)"};
        this.portRateSelect = new JComboBox<String>(portRates);
        connectionPane.add(new JLabel("Port Speed (SW1,SW0):"));
        connectionPane.add(this.portRateSelect);
        this.add((Component)connectionPane, DeviceController.createConstraints(0, 0, 1, 1, 1.0, 0.5));
        JPanel settingsPane = new JPanel();
        settingsPane.setLayout(new GridLayout(5, 2, 5, 5));
        settingsPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Analyzer Settings"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        String[] sources = new String[]{"Internal", "External / Rising", "External / Falling"};
        this.sourceSelect = new JComboBox<String>(sources);
        this.sourceSelect.addActionListener(this);
        settingsPane.add(new JLabel("Sampling Clock:"));
        settingsPane.add(this.sourceSelect);
        String[] speeds = new String[]{"200MHz", "100MHz", "50MHz", "20MHz", "10MHz", "5MHz", "2MHz", "1MHz", "500kHz", "200kHz", "100kHz", "50kHz", "20kHz", "10kHz", "1kHz", "500Hz", "200Hz", "100Hz", "50Hz", "20Hz", "10Hz"};
        this.speedSelect = new JComboBox<String>(speeds);
        this.speedSelect.setSelectedIndex(1);
        this.speedSelect.addActionListener(this);
        settingsPane.add(new JLabel("Sampling Rate:"));
        settingsPane.add(this.speedSelect);
        Container groups = new Container();
        groups.setLayout(new GridLayout(1, 4));
        this.channelGroup = new JCheckBox[4];
        int i = 0;
        while (i < this.channelGroup.length) {
            this.channelGroup[i] = new JCheckBox(Integer.toString(i));
            this.channelGroup[i].setSelected(true);
            groups.add(this.channelGroup[i]);
            ++i;
        }
        settingsPane.add(new JLabel("Channel Groups:"));
        settingsPane.add(groups);
        String[] sizes = new String[]{"256K", "128K", "64K", "32K", "16K", "8K", "4K", "2K", "1K", "512", "256", "128", "64"};
        this.sizeSelect = new JComboBox<String>(sizes);
        this.sizeSelect.setSelectedIndex(7);
        settingsPane.add(new JLabel("Recording Size:"));
        settingsPane.add(this.sizeSelect);
        this.add((Component)settingsPane, DeviceController.createConstraints(0, 1, 1, 1, 1.0, 0.5));
        this.filterEnable = new JCheckBox("Enable");
        this.filterEnable.setSelected(true);
        this.filterEnable.setEnabled(false);
        settingsPane.add(new JLabel("Noise Filter: "));
        settingsPane.add(this.filterEnable);
        JPanel triggerPane = new JPanel();
        triggerPane.setLayout(new GridBagLayout());
        triggerPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Trigger Settings"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.triggerEnable = new JCheckBox("Enable");
        this.triggerEnable.addActionListener(this);
        triggerPane.add((Component)new JLabel("Trigger: "), DeviceController.createConstraints(0, 0, 1, 1, 0.0, 1.0));
        triggerPane.add((Component)this.triggerEnable, DeviceController.createConstraints(1, 0, 1, 1, 0.0, 1.0));
        triggerPane.add((Component)new JLabel(), DeviceController.createConstraints(2, 0, 1, 1, 10.0, 1.0));
        String[] ratios = new String[]{"0/100", "25/75", "50/50", "75/25", "100/0"};
        this.ratioSelect = new JComboBox<String>(ratios);
        this.ratioSelect.setSelectedIndex(2);
        triggerPane.add((Component)new JLabel("Before/After Ratio: "), DeviceController.createConstraints(0, 1, 1, 1, 0.5, 1.0));
        triggerPane.add((Component)this.ratioSelect, DeviceController.createConstraints(1, 1, 1, 1, 0.5, 1.0));
        String[] types = new String[]{"Simple", "Complex"};
        this.triggerTypeSelect = new JComboBox<String>(types);
        this.triggerTypeSelect.addActionListener(this);
        triggerPane.add((Component)new JLabel("Type: "), DeviceController.createConstraints(0, 2, 1, 1, 0.5, 1.0));
        triggerPane.add((Component)this.triggerTypeSelect, DeviceController.createConstraints(1, 2, 1, 1, 0.5, 1.0));
        triggerPane.add((Component)new JLabel(" "), DeviceController.createConstraints(0, 3, 1, 1, 1.0, 1.0));
        this.triggerStageTabs = new JTabbedPane();
        this.triggerStages = this.device.getTriggerStageCount();
        this.triggerMask = new JCheckBox[4][];
        this.triggerValue = new JCheckBox[4][];
        this.triggerLevel = new JComboBox[4];
        this.triggerDelay = new JTextField[4];
        this.triggerMode = new JComboBox[4];
        this.triggerChannel = new JComboBox[4];
        this.triggerStart = new JCheckBox[4];
        int i2 = 0;
        while (i2 < this.triggerStages) {
            JPanel stagePane = new JPanel();
            stagePane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            stagePane.setLayout(new GridBagLayout());
            String[] levels = new String[]{"Immediatly", "On Level 1", "On Level 2", "On Level 3"};
            this.triggerLevel[i2] = new JComboBox<String>(levels);
            if (i2 > 0) {
                this.triggerLevel[i2].setSelectedIndex(3);
            }
            stagePane.add((Component)new JLabel("Arm:"), DeviceController.createConstraints(0, 0, 1, 1, 1.0, 1.0));
            stagePane.add((Component)this.triggerLevel[i2], DeviceController.createConstraints(1, 0, 1, 1, 0.5, 1.0));
            String[] modes = new String[]{"Parallel", "Serial"};
            this.triggerMode[i2] = new JComboBox<String>(modes);
            stagePane.add((Component)new JLabel("Mode:", 4), DeviceController.createConstraints(2, 0, 1, 1, 0.5, 1.0));
            stagePane.add((Component)this.triggerMode[i2], DeviceController.createConstraints(3, 0, 1, 1, 0.5, 1.0));
            this.triggerMode[i2].addActionListener(this);
            String[] channels = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
            this.triggerChannel[i2] = new JComboBox<String>(channels);
            stagePane.add((Component)new JLabel("Channel:", 4), DeviceController.createConstraints(4, 0, 1, 1, 0.5, 1.0));
            stagePane.add((Component)this.triggerChannel[i2], DeviceController.createConstraints(5, 0, 1, 1, 0.5, 1.0));
            stagePane.add((Component)new JLabel("31"), DeviceController.createConstraints(1, 1, 1, 1, 1.0, 1.0));
            stagePane.add((Component)new JLabel("0", 4), DeviceController.createConstraints(5, 1, 1, 1, 1.0, 1.0));
            stagePane.add((Component)new JLabel("Mask:"), DeviceController.createConstraints(0, 2, 1, 1, 1.0, 1.0));
            this.triggerMask[i2] = this.createChannelList(stagePane, DeviceController.createConstraints(1, 2, 5, 1, 1.0, 1.0));
            stagePane.add((Component)new JLabel("Value:"), DeviceController.createConstraints(0, 3, 1, 1, 1.0, 1.0));
            this.triggerValue[i2] = this.createChannelList(stagePane, DeviceController.createConstraints(1, 3, 5, 1, 1.0, 1.0));
            stagePane.add((Component)new JLabel("Action:"), DeviceController.createConstraints(0, 4, 1, 1, 1.0, 1.0));
            this.triggerStart[i2] = new JCheckBox("Start Capture    (otherwise trigger level will rise by one)");
            stagePane.add((Component)this.triggerStart[i2], DeviceController.createConstraints(1, 4, 3, 1, 1.0, 1.0));
            stagePane.add((Component)new JLabel("Delay:", 4), DeviceController.createConstraints(4, 4, 1, 1, 0.5, 1.0));
            this.triggerDelay[i2] = new JTextField("0");
            stagePane.add((Component)this.triggerDelay[i2], DeviceController.createConstraints(5, 4, 1, 1, 0.5, 1.0));
            this.triggerStageTabs.add("Stage " + i2, stagePane);
            ++i2;
        }
        triggerPane.add((Component)this.triggerStageTabs, DeviceController.createConstraints(0, 4, 3, 1, 1.0, 1.0));
        this.add((Component)triggerPane, DeviceController.createConstraints(1, 0, 2, 2, 1.0, 0.5));
        JPanel progressPane = new JPanel();
        progressPane.setLayout(new BorderLayout());
        progressPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Progress"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.progress = new JProgressBar(0, 100);
        progressPane.add((Component)this.progress, "Center");
        this.add((Component)progressPane, DeviceController.createConstraints(0, 2, 3, 1, 1.0, 0.0));
        this.add((Component)new JLabel(), DeviceController.createConstraints(0, 3, 1, 1, 0.5, 0.0));
        this.captureButton = new JButton("Capture");
        this.captureButton.addActionListener(this);
        this.add((Component)this.captureButton, DeviceController.createConstraints(1, 3, 1, 1, 0.5, 0.0));
        JButton cancel = new JButton("Close");
        cancel.addActionListener(this);
        this.add((Component)cancel, DeviceController.createConstraints(2, 3, 1, 1, 0.5, 0.0));
        this.capturedData = null;
        this.timer = null;
        this.worker = null;
        this.status = 0;
    }

    private void initDialog(JFrame frame) {
        if (this.dialog != null && this.dialog.getOwner() != frame) {
            this.dialog.dispose();
            this.dialog = null;
        }
        if (this.dialog == null) {
            this.dialog = new JDialog(frame, "Capture", true);
            this.dialog.getContentPane().add(this);
            this.dialog.setResizable(false);
            this.dialog.setSize(this.getPreferredSize());
        }
        this.progress.setValue(0);
        this.updateFields();
    }

    public CapturedData getDeviceData() {
        return this.capturedData;
    }

    private int smartParseInt(String s) {
        int val = 0;
        try {
            int i = 1;
            while (i <= s.length()) {
                val = Integer.parseInt(s.substring(0, i));
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    private void setTriggerEnabled(boolean enable) {
        int channels = this.device.getAvailableChannelCount();
        boolean complex = "Complex".equals((String)this.triggerTypeSelect.getSelectedItem());
        if (!complex) {
            this.triggerStageTabs.setSelectedIndex(0);
        }
        this.triggerTypeSelect.setEnabled(enable);
        this.ratioSelect.setEnabled(enable);
        int stage = 0;
        while (stage < this.triggerStages) {
            int i = 0;
            while (i < channels) {
                this.triggerMask[stage][i].setEnabled(enable);
                this.triggerValue[stage][i].setEnabled(enable);
                ++i;
            }
            i = channels;
            while (i < 32) {
                this.triggerMask[stage][i].setEnabled(false);
                this.triggerValue[stage][i].setEnabled(false);
                ++i;
            }
            this.triggerStageTabs.setEnabledAt(stage, enable && (stage == 0 || complex));
            this.triggerLevel[stage].setEnabled(enable && complex);
            this.triggerDelay[stage].setEnabled(enable);
            this.triggerMode[stage].setEnabled(enable);
            if (enable && this.triggerMode[stage].getSelectedIndex() == 1) {
                this.triggerChannel[stage].setEnabled(true);
            } else {
                this.triggerChannel[stage].setEnabled(false);
            }
            this.triggerStart[stage].setEnabled(enable && complex);
            ++stage;
        }
    }

    private void setDialogEnabled(boolean enable) {
        this.triggerEnable.setEnabled(enable);
        this.captureButton.setEnabled(enable);
        this.portSelect.setEnabled(enable);
        this.portRateSelect.setEnabled(enable);
        this.speedSelect.setEnabled(enable);
        this.sizeSelect.setEnabled(enable);
        this.updateFields(enable);
    }

    public void updateFields() {
        this.updateFields(true);
    }

    private void updateFields(boolean enable) {
        this.triggerEnable.setSelected(this.device.isTriggerEnabled());
        this.setTriggerEnabled(this.device.isTriggerEnabled());
        this.filterEnable.setEnabled(this.device.isFilterAvailable() && enable);
        int i = 0;
        while (i < this.channelGroup.length) {
            this.channelGroup[i].setEnabled(enable && i < this.device.getAvailableChannelCount() / 8);
            ++i;
        }
        this.speedSelect.setEnabled(this.device.getClockSource() == 0);
    }

    private void updateDevice() {
        String value = (String)this.sourceSelect.getSelectedItem();
        if (value.equals("Internal")) {
            this.device.setClockSource(0);
        } else if (value.equals("External / Rising")) {
            this.device.setClockSource(1);
        } else {
            this.device.setClockSource(2);
        }
        value = (String)this.speedSelect.getSelectedItem();
        int f = this.smartParseInt(value);
        if (value.indexOf("M") > 0) {
            f *= 1000000;
        } else if (value.indexOf("k") > 0) {
            f *= 1000;
        }
        this.device.setRate(f);
        value = (String)this.sizeSelect.getSelectedItem();
        int s = this.smartParseInt(value);
        if (value.indexOf("K") > 0) {
            s *= 1024;
        }
        this.device.setSize(s);
        value = (String)this.ratioSelect.getSelectedItem();
        double r = 0.5;
        if (value.equals("100/0")) {
            r = 0.0;
        } else if (value.equals("25/75")) {
            r = 0.75;
        } else if (value.equals("50/50")) {
            r = 0.5;
        } else if (value.equals("75/25")) {
            r = 0.25;
        } else if (value.equals("0/100")) {
            r = 1.0;
        }
        this.device.setRatio(r);
        this.device.setFilterEnabled(this.filterEnable.isSelected());
        boolean triggerEnabled = this.triggerEnable.isSelected();
        this.device.setTriggerEnabled(triggerEnabled);
        if (triggerEnabled) {
            boolean complex = "Complex".equals((String)this.triggerTypeSelect.getSelectedItem());
            int stage = 0;
            while (stage < this.triggerStages) {
                int m = 0;
                int v = 0;
                int i = 0;
                while (i < 32) {
                    if (this.triggerMask[stage][i].isSelected()) {
                        m |= 1 << i;
                    }
                    if (this.triggerValue[stage][i].isSelected()) {
                        v |= 1 << i;
                    }
                    ++i;
                }
                int level = this.triggerLevel[stage].getSelectedIndex();
                int delay = this.smartParseInt(this.triggerDelay[stage].getText());
                int channel = this.triggerChannel[stage].getSelectedIndex();
                boolean startCapture = this.triggerStart[stage].isSelected();
                if (complex) {
                    if (this.triggerMode[stage].getSelectedIndex() == 0) {
                        this.device.setParallelTrigger(stage, m, v, level, delay, startCapture);
                    } else {
                        this.device.setSerialTrigger(stage, channel, m, v, level, delay, startCapture);
                    }
                } else if (stage == 0) {
                    if (this.triggerMode[stage].getSelectedIndex() == 0) {
                        this.device.setParallelTrigger(stage, m, v, 0, delay, true);
                    } else {
                        this.device.setSerialTrigger(stage, channel, m, v, 0, delay, true);
                    }
                } else {
                    this.device.setParallelTrigger(stage, 0, 0, 3, 0, false);
                }
                ++stage;
            }
        }
        int enabledChannels = 0;
        int i = 0;
        while (i < this.channelGroup.length) {
            if (this.channelGroup[i].isSelected()) {
                enabledChannels |= 255 << 8 * i;
            }
            ++i;
        }
        this.device.setEnabledChannels(enabledChannels);
    }

    public void run() {
        block2: {
            this.device.attach((String)this.portSelect.getSelectedItem(), this.smartParseInt((String)this.portRateSelect.getSelectedItem()));
            this.status = 1;
            try {
                System.out.println("Run started");
                this.errorMessage = "";
                this.capturedData = this.device.run();
                System.out.println("Run completed");
                this.status = 3;
            }
            catch (Exception ex) {
                this.capturedData = null;
                this.status = 2;
                System.out.println("Run aborted");
                if (ex instanceof InterruptedException) break block2;
                this.errorMessage = ex.getMessage();
                ex.printStackTrace(System.out);
            }
        }
        this.device.detach();
    }

    private void close() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (this.worker != null) {
            this.device.stop();
            this.worker.interrupt();
            this.worker = null;
        }
        this.dialog.hide();
    }

    private void startCapture() {
        try {
            this.setDialogEnabled(false);
            this.timer = new Timer(100, this);
            this.worker = new Thread(this);
            this.timer.start();
            this.worker.start();
        }
        catch (Exception E) {
            E.printStackTrace(System.out);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object o = event.getSource();
        String l = event.getActionCommand();
        if (this.dialog == null || !this.dialog.isVisible()) {
            return;
        }
        if (o == this.timer) {
            if (this.status == 3) {
                this.close();
            } else if (this.status == 2) {
                this.timer.stop();
                JOptionPane.showMessageDialog(this, "Error while trying to communicate with device:\n\n\"" + this.errorMessage + "\"\n\n" + "Make sure the device is:\n" + " - connected to the specified port\n" + " - turned on and properly programmed\n" + " - set to the selected transfer rate\n", "Communication Error", 0);
                this.setDialogEnabled(true);
            } else if (this.device.isRunning()) {
                this.progress.setValue(this.device.getPercentage());
            }
        } else if (o == this.triggerEnable) {
            this.updateDevice();
            this.updateFields();
        } else if (o == this.sourceSelect) {
            this.updateDevice();
            this.updateFields();
        } else if (o == this.speedSelect) {
            this.updateDevice();
            this.updateFields();
        } else if (l.equals("Capture")) {
            this.updateDevice();
            this.startCapture();
        } else if (l.equals("Close")) {
            this.close();
        } else {
            this.updateFields();
        }
    }

    private void selectByValue(JComboBox box, String value) {
        if (value != null) {
            int i = 0;
            while (i < box.getItemCount()) {
                if (value.equals((String)box.getItemAt(i))) {
                    box.setSelectedIndex(i);
                }
                ++i;
            }
        }
    }

    public void readProperties(Properties properties) {
        this.selectByValue(this.portSelect, properties.getProperty("DeviceController.port"));
        this.selectByValue(this.portRateSelect, properties.getProperty("DeviceController.portRate"));
        this.selectByValue(this.sourceSelect, properties.getProperty("DeviceController.source"));
        this.selectByValue(this.speedSelect, properties.getProperty("DeviceController.speed"));
        this.selectByValue(this.sizeSelect, properties.getProperty("DeviceController.size"));
        this.selectByValue(this.ratioSelect, properties.getProperty("DeviceController.ratio"));
        this.filterEnable.setSelected("true".equals(properties.getProperty("DeviceController.filter")));
        this.triggerEnable.setSelected("true".equals(properties.getProperty("DeviceController.trigger")));
        this.selectByValue(this.triggerTypeSelect, properties.getProperty("DeviceController.triggerType"));
        int stage = 0;
        while (stage < this.triggerStages) {
            String value;
            this.selectByValue(this.triggerLevel[stage], properties.getProperty("DeviceController.triggerStage" + stage + "Level"));
            this.triggerDelay[stage].setText(properties.getProperty("DeviceController.triggerStage" + stage + "Delay"));
            this.selectByValue(this.triggerMode[stage], properties.getProperty("DeviceController.triggerStage" + stage + "Mode"));
            this.selectByValue(this.triggerChannel[stage], properties.getProperty("DeviceController.triggerStage" + stage + "Channel"));
            String mask = properties.getProperty("DeviceController.triggerStage" + stage + "Mask");
            if (mask != null) {
                int i = 0;
                while (i < 32 && i < mask.length()) {
                    this.triggerMask[stage][i].setSelected(mask.charAt(i) == '1');
                    ++i;
                }
            }
            if ((value = properties.getProperty("DeviceController.triggerStage" + stage + "Value")) != null) {
                int i = 0;
                while (i < 32 && i < value.length()) {
                    this.triggerValue[stage][i].setSelected(value.charAt(i) == '1');
                    ++i;
                }
            }
            this.triggerStart[stage].setSelected("true".equals(properties.getProperty("DeviceController.triggerStage" + stage + "StartCapture")));
            ++stage;
        }
        String group = properties.getProperty("DeviceController.channelGroup");
        if (group != null) {
            int i = 0;
            while (i < 4 && i < group.length()) {
                this.channelGroup[i].setSelected(group.charAt(i) == '1');
                ++i;
            }
        }
        this.updateDevice();
        this.updateFields();
    }

    public void writeProperties(Properties properties) {
        properties.setProperty("DeviceController.port", (String)this.portSelect.getSelectedItem());
        properties.setProperty("DeviceController.portRate", (String)this.portRateSelect.getSelectedItem());
        properties.setProperty("DeviceController.source", (String)this.sourceSelect.getSelectedItem());
        properties.setProperty("DeviceController.speed", (String)this.speedSelect.getSelectedItem());
        properties.setProperty("DeviceController.size", (String)this.sizeSelect.getSelectedItem());
        properties.setProperty("DeviceController.ratio", (String)this.ratioSelect.getSelectedItem());
        properties.setProperty("DeviceController.filter", this.filterEnable.isSelected() ? "true" : "false");
        properties.setProperty("DeviceController.trigger", this.triggerEnable.isSelected() ? "true" : "false");
        properties.setProperty("DeviceController.triggerType", (String)this.triggerTypeSelect.getSelectedItem());
        int stage = 0;
        while (stage < this.triggerStages) {
            properties.setProperty("DeviceController.triggerStage" + stage + "Level", (String)this.triggerLevel[stage].getSelectedItem());
            properties.setProperty("DeviceController.triggerStage" + stage + "Delay", this.triggerDelay[stage].getText());
            properties.setProperty("DeviceController.triggerStage" + stage + "Mode", (String)this.triggerMode[stage].getSelectedItem());
            properties.setProperty("DeviceController.triggerStage" + stage + "Channel", (String)this.triggerChannel[stage].getSelectedItem());
            StringBuffer mask = new StringBuffer();
            int i = 0;
            while (i < 32) {
                mask.append(this.triggerMask[stage][i].isSelected() ? "1" : "0");
                ++i;
            }
            properties.setProperty("DeviceController.triggerStage" + stage + "Mask", mask.toString());
            StringBuffer value = new StringBuffer();
            int i2 = 0;
            while (i2 < 32) {
                value.append(this.triggerValue[stage][i2].isSelected() ? "1" : "0");
                ++i2;
            }
            properties.setProperty("DeviceController.triggerStage" + stage + "Value", value.toString());
            properties.setProperty("DeviceController.triggerStage" + stage + "StartCapture", this.triggerStart[stage].isSelected() ? "true" : "false");
            ++stage;
        }
        StringBuffer group = new StringBuffer();
        int i = 0;
        while (i < 4) {
            group.append(this.channelGroup[i].isSelected() ? "1" : "0");
            ++i;
        }
        properties.setProperty("DeviceController.channelGroup", group.toString());
    }

    public int showCaptureDialog(JFrame frame) throws Exception {
        this.status = 0;
        this.initDialog(frame);
        this.setDialogEnabled(true);
        this.dialog.show();
        return this.status;
    }

    public int showCaptureProgress(JFrame frame) throws Exception {
        this.status = 0;
        this.initDialog(frame);
        this.startCapture();
        this.dialog.show();
        return this.status;
    }
}

