/*
 * Decompiled with CFR 0.152.
 */
package org.sump.analyzer;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import org.sump.analyzer.CapturedData;

public class Device {
    public static final int CLOCK_INTERNAL = 0;
    public static final int CLOCK_EXTERNAL_RISING = 1;
    public static final int CLOCK_EXTERNAL_FALLING = 2;
    private static final int SETTRIGMASK = 192;
    private static final int SETTRIGVAL = 193;
    private static final int SETTRIGCFG = 194;
    private static final int SETDIVIDER = 128;
    private static final int SETSIZE = 129;
    private static final int SETFLAGS = 130;
    private static final int RESET = 0;
    private static final int RUN = 1;
    private static final int ID = 2;
    private static final int XON = 17;
    private static final int XOFF = 19;
    private static final int FLAG_DEMUX = 1;
    private static final int FLAG_FILTER = 2;
    private static final int FLAG_DISABLE_G0 = 4;
    private static final int FLAG_DISABLE_G1 = 8;
    private static final int FLAG_DISABLE_G2 = 16;
    private static final int FLAG_DISABLE_G3 = 32;
    private static final int FLAG_EXTERNAL = 64;
    private static final int FLAG_INVERTED = 128;
    private static final int TRIGGER_DELAYMASK = 65535;
    private static final int TRIGGER_LEVELMASK = 196608;
    private static final int TRIGGER_CHANNELMASK = 0x1F00000;
    private static final int TRIGGER_SERIAL = 0x4000000;
    private static final int TRIGGER_CAPTURE = 0x8000000;
    private static final int CLOCK = 100000000;
    private static final int TRIGGER_STAGES = 4;
    private SerialPort port;
    private InputStream inputStream;
    private OutputStream outputStream;
    private boolean running;
    private int percentageDone;
    private int clockSource;
    private boolean demux;
    private boolean filterEnabled;
    private boolean triggerEnabled;
    private int[] triggerMask = new int[4];
    private int[] triggerValue = new int[4];
    private int[] triggerConfig = new int[4];
    private int enabledChannels;
    private boolean[] enabledGroups;
    private int divider;
    private int size;
    private double ratio;

    public Device() {
        int i = 0;
        while (i < 4) {
            this.triggerMask[i] = 0;
            this.triggerValue[i] = 0;
            this.triggerConfig[i] = 0;
            ++i;
        }
        this.triggerEnabled = false;
        this.filterEnabled = false;
        this.demux = false;
        this.setClockSource(0);
        this.divider = 0;
        this.ratio = 0.5;
        this.size = 512;
        this.enabledGroups = new boolean[4];
        this.setEnabledChannels(-1);
        this.percentageDone = -1;
        this.stop();
        this.port = null;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    public void setRate(int rate) {
        if (rate > 100000000) {
            this.demux = true;
            this.divider = 200000000 / rate - 1;
        } else {
            this.demux = false;
            this.divider = 100000000 / rate - 1;
        }
    }

    public void setParallelTrigger(int stage, int mask, int value, int level, int delay, boolean startCapture) {
        if (!this.demux) {
            this.triggerMask[stage] = mask;
            this.triggerValue[stage] = value;
        } else {
            this.triggerMask[stage] = mask & 0xFFFF;
            this.triggerValue[stage] = value & 0xFFFF;
            int n = stage;
            this.triggerMask[n] = this.triggerMask[n] | this.triggerMask[stage] << 16;
            int n2 = stage;
            this.triggerValue[n2] = this.triggerValue[n2] | this.triggerValue[stage] << 16;
        }
        this.triggerConfig[stage] = 0;
        int n = stage;
        this.triggerConfig[n] = this.triggerConfig[n] | delay & 0xFFFF;
        int n3 = stage;
        this.triggerConfig[n3] = this.triggerConfig[n3] | level << 16 & 0x30000;
        if (startCapture) {
            int n4 = stage;
            this.triggerConfig[n4] = this.triggerConfig[n4] | 0x8000000;
        }
    }

    public void setSerialTrigger(int stage, int channel, int mask, int value, int level, int delay, boolean startCapture) {
        if (!this.demux) {
            this.triggerMask[stage] = mask;
            this.triggerValue[stage] = value;
        } else {
            this.triggerMask[stage] = mask & 0xFFFF;
            this.triggerValue[stage] = value & 0xFFFF;
            int n = stage;
            this.triggerMask[n] = this.triggerMask[n] | this.triggerMask[stage] << 16;
            int n2 = stage;
            this.triggerValue[n2] = this.triggerValue[n2] | this.triggerValue[stage] << 16;
        }
        this.triggerConfig[stage] = 0;
        int n = stage;
        this.triggerConfig[n] = this.triggerConfig[n] | delay & 0xFFFF;
        int n3 = stage;
        this.triggerConfig[n3] = this.triggerConfig[n3] | level << 16 & 0x30000;
        int n4 = stage;
        this.triggerConfig[n4] = this.triggerConfig[n4] | channel << 20 & 0x1F00000;
        int n5 = stage;
        this.triggerConfig[n5] = this.triggerConfig[n5] | 0x4000000;
        if (startCapture) {
            int n6 = stage;
            this.triggerConfig[n6] = this.triggerConfig[n6] | 0x8000000;
        }
    }

    public void setTriggerEnabled(boolean enable) {
        this.triggerEnabled = enable;
    }

    public void setFilterEnabled(boolean enable) {
        this.filterEnabled = enable;
    }

    public void setEnabledChannels(int mask) {
        this.enabledChannels = mask;
        int i = 0;
        while (i < 4) {
            this.enabledGroups[i] = (this.enabledChannels >> 8 * i & 0xFF) > 0;
            ++i;
        }
    }

    public void setClockSource(int source) {
        this.clockSource = source;
    }

    public int getMaximumRate() {
        return 200000000;
    }

    public int getTriggerMask(int stage) {
        return this.triggerMask[stage];
    }

    public int getTriggerValue(int stage) {
        return this.triggerValue[stage];
    }

    public int getClockSource() {
        return this.clockSource;
    }

    public int getEnabledChannels() {
        return this.enabledChannels;
    }

    public boolean isTriggerEnabled() {
        return this.triggerEnabled;
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public boolean isFilterAvailable() {
        return !this.demux && this.clockSource == 0;
    }

    public int getTriggerStageCount() {
        return 4;
    }

    public int getAvailableChannelCount() {
        if (this.demux && this.clockSource == 0) {
            return 16;
        }
        return 32;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPercentage() {
        return this.percentageDone;
    }

    public static String[] getPorts() {
        Enumeration portIdentifiers = CommPortIdentifier.getPortIdentifiers();
        LinkedList<String> portList = new LinkedList<String>();
        CommPortIdentifier portId = null;
        while (portIdentifiers.hasMoreElements()) {
            portId = (CommPortIdentifier)portIdentifiers.nextElement();
            if (portId.getPortType() != 1) continue;
            portList.addLast(portId.getName());
            System.out.println(portId.getName());
        }
        return portList.toArray(new String[1]);
    }

    public boolean attach(String portName, int portRate) {
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        CommPortIdentifier portId = null;
        boolean found = false;
        System.out.println("Attaching to: " + portName + " (" + portRate + "bps)");
        try {
            this.detach();
            while (!found && portList.hasMoreElements()) {
                portId = (CommPortIdentifier)portList.nextElement();
                if (portId.getPortType() != 1 || !portId.getName().equals(portName)) continue;
                found = true;
            }
            if (found) {
                this.port = (SerialPort)portId.open("Logic Analyzer Client", 1000);
                this.port.setSerialPortParams(portRate, 8, 1, 0);
                this.port.setFlowControlMode(4);
                this.port.disableReceiveFraming();
                this.port.enableReceiveTimeout(100);
                this.outputStream = this.port.getOutputStream();
                this.inputStream = this.port.getInputStream();
            }
        }
        catch (Exception E) {
            E.printStackTrace(System.out);
            return false;
        }
        return found;
    }

    public void detach() {
        if (this.port != null) {
            try {
                if (this.outputStream != null) {
                    int i = 0;
                    while (i < 5) {
                        this.sendCommand(0);
                        ++i;
                    }
                    this.outputStream.close();
                }
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.port.close();
        }
    }

    private void sendCommand(int opcode, int data) throws IOException {
        byte[] raw = new byte[5];
        int mask = 255;
        int shift = 0;
        raw[0] = (byte)opcode;
        int i = 1;
        while (i < 5) {
            raw[i] = (byte)((data & mask) >> shift);
            mask <<= 8;
            shift += 8;
            ++i;
        }
        String debugCmd = "";
        int j = 0;
        while (j < 5) {
            int i2 = 7;
            while (i2 >= 0) {
                debugCmd = (raw[j] & 1 << i2) != 0 ? String.valueOf(debugCmd) + "1" : String.valueOf(debugCmd) + "0";
                --i2;
            }
            debugCmd = String.valueOf(debugCmd) + " ";
            ++j;
        }
        System.out.println(debugCmd);
        this.outputStream.write(raw);
    }

    private void sendCommand(int opcode) throws IOException {
        byte raw = (byte)opcode;
        this.outputStream.write(raw);
    }

    private int readSample(int channels) throws IOException, InterruptedException {
        int value = 0;
        int i = 0;
        while (i < channels / 8) {
            int v = this.enabledGroups[i] ? this.inputStream.read() : 0;
            if (v < 0 || Thread.interrupted()) {
                throw new InterruptedException("Data readout interrupted.");
            }
            value |= v << 8 * i;
            ++i;
        }
        return value;
    }

    private int readInteger() throws IOException, InterruptedException {
        int value = 0;
        int i = 0;
        while (i < 4) {
            int v = this.inputStream.read();
            if (v < 0 || Thread.interrupted()) {
                throw new InterruptedException("Data readout interrupted.");
            }
            value |= v << 8 * i;
            ++i;
        }
        return value;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CapturedData run() throws IOException, InterruptedException {
        block32: {
            block31: {
                block30: {
                    this.running = true;
                    i = 0;
                    while (true) {
                        if (i >= 5) {
                            this.sendCommand(2);
                            id = 0;
                            ** try [egrp 0[TRYBLOCK] [0 : 30->38)] { 
lbl8:
                            // 1 sources

                            break;
                        }
                        this.sendCommand(0);
                        ++i;
                    }
                    {
                        id = this.readInteger();
                    }
lbl14:
                    // 1 sources

                    catch (Exception var2_2) {
                        // empty catch block
                    }
                    System.out.println("Device ID: 0x" + Integer.toHexString(id));
                    if (id == 1397506352) {
                        throw new IOException("Device is obsolete. Please upgrade Firmware.");
                    }
                    if (id != 1397506353) {
                        throw new IOException("Device not found.");
                    }
                    stopCounter = (int)((double)this.size * this.ratio);
                    readCounter = this.size;
                    if (this.triggerEnabled) {
                        i = 0;
                        while (true) {
                            if (i >= 4) {
                                effectiveStopCounter = stopCounter;
                                break block30;
                            }
                            this.sendCommand(192 + 4 * i, this.triggerMask[i]);
                            this.sendCommand(193 + 4 * i, this.triggerValue[i]);
                            this.sendCommand(194 + 4 * i, this.triggerConfig[i]);
                            ++i;
                        }
                    }
                    this.sendCommand(192, 0);
                    this.sendCommand(193, 0);
                    this.sendCommand(194, 0x8000000);
                    effectiveStopCounter = readCounter;
                }
                this.sendCommand(128, this.divider);
                flags = 0;
                if (this.clockSource == 1 || this.clockSource == 2) {
                    flags |= 64;
                    if (this.clockSource == 2) {
                        flags |= 128;
                    }
                }
                if (this.demux && this.clockSource == 0) {
                    flags |= 1;
                    i = 0;
                    while (true) {
                        if (i >= 2) {
                            this.sendCommand(129, (effectiveStopCounter - 8 & 524280) << 13 | ((readCounter & 524280) >> 3) - 1);
                            break block31;
                        }
                        if (!this.enabledGroups[i]) {
                            flags |= 4 << i;
                            flags |= 16 << i;
                        }
                        ++i;
                    }
                }
                if (this.filterEnabled && this.isFilterAvailable()) {
                    flags |= 2;
                }
                i = 0;
                while (true) {
                    if (i >= 4) {
                        this.sendCommand(129, (effectiveStopCounter - 4 & 262140) << 14 | ((readCounter & 262140) >> 2) - 1);
                        break;
                    }
                    if (!this.enabledGroups[i]) {
                        flags |= 4 << i;
                    }
                    ++i;
                }
            }
            System.out.println("Flags: " + Integer.toString(flags, 2));
            this.sendCommand(130, flags);
            this.sendCommand(1);
            if (this.demux && this.clockSource == 0) {
                channels = 16;
                samples = readCounter & 1048568;
            } else {
                channels = 32;
                samples = readCounter & 1048572;
            }
            buffer = new int[samples];
            wait = true;
            while (true) lbl-1000:
            // 3 sources

            {
                if (!wait) {
                    ** try [egrp 2[TRYBLOCK] [2 : 596->643)] { 
lbl83:
                    // 1 sources

                    ** break;
                }
                try {
                    buffer[samples - 1] = this.readSample(channels);
                    wait = false;
                }
                catch (InterruptedException e) {
                    if (!this.running) ** break;
                    continue;
                    this.percentageDone = -1;
                    throw e;
                }
                break;
            }
            {
                ** GOTO lbl-1000
lbl94:
                // 1 sources

                i = samples - 2;
                while (i >= 0) {
                    buffer[i] = this.readSample(channels);
                    this.percentageDone = 100 - 100 * i / buffer.length;
                    --i;
                }
            }
lbl101:
            // 1 sources

            catch (Throwable var11_15) {
                e = null;
                this.percentageDone = -1;
                throw var11_15;
            }
            {
                e = null;
                this.percentageDone = -1;
                pos = -1;
                if (!this.triggerEnabled) break block32;
            }
            pos = readCounter - stopCounter - 3 - 4 / (this.divider + 1) - (this.demux != false ? 5 : 0);
        }
        rate = -1;
        if (this.clockSource == 0) {
            rate = this.demux != false ? 200000000 / (this.divider + 1) : 100000000 / (this.divider + 1);
        }
        return new CapturedData(buffer, pos, rate, channels, this.enabledChannels);
    }

    public void stop() {
        this.running = false;
    }
}

