/*
 * Decompiled with CFR 0.152.
 */
package org.sump.analyzer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class CapturedData {
    public static final int NOT_AVAILABLE = -1;
    public final int[] values;
    public final int triggerPosition;
    public final int rate;
    public final int channels;
    public final int enabledChannels;

    public CapturedData(int[] values, int triggerPosition, int rate, int channels, int enabledChannels) {
        this.values = values;
        this.triggerPosition = triggerPosition;
        this.rate = rate;
        this.channels = channels;
        this.enabledChannels = enabledChannels;
    }

    public CapturedData(File file) throws IOException {
        String line;
        int size = 0;
        int r = -1;
        int t = -1;
        int channels = 32;
        int enabledChannels = -1;
        BufferedReader br = new BufferedReader(new FileReader(file));
        do {
            if ((line = br.readLine()) == null) {
                throw new IOException("File appears to be corrupted.");
            }
            if (line.startsWith(";Size: ")) {
                size = Integer.parseInt(line.substring(7));
                continue;
            }
            if (line.startsWith(";Rate: ")) {
                r = Integer.parseInt(line.substring(7));
                continue;
            }
            if (line.startsWith(";Channels: ")) {
                channels = Integer.parseInt(line.substring(11));
                continue;
            }
            if (line.startsWith(";TriggerPosition: ")) {
                t = Integer.parseInt(line.substring(18));
                continue;
            }
            if (!line.startsWith(";EnabledChannels: ")) continue;
            enabledChannels = Integer.parseInt(line.substring(18));
        } while (line.startsWith(";"));
        if (size <= 0 || size > 262144) {
            throw new IOException("Invalid size encountered.");
        }
        this.values = new int[size];
        try {
            int i = 0;
            while (i < this.values.length && line != null) {
                this.values[i] = channels > 16 ? Integer.parseInt(line.substring(0, 4), 16) << 16 | Integer.parseInt(line.substring(4, 8), 16) : Integer.parseInt(line.substring(0, 4), 16);
                line = br.readLine();
                ++i;
            }
        }
        catch (NumberFormatException E) {
            throw new IOException("Invalid data encountered.");
        }
        this.triggerPosition = t;
        this.rate = r;
        this.channels = channels;
        this.enabledChannels = enabledChannels;
        br.close();
    }

    public void writeToFile(File file) throws IOException {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(";Size: " + this.values.length);
            bw.newLine();
            bw.write(";Rate: " + this.rate);
            bw.newLine();
            bw.write(";Channels: " + this.channels);
            bw.newLine();
            bw.write(";EnabledChannels: " + this.enabledChannels);
            bw.newLine();
            if (this.triggerPosition >= 0) {
                bw.write(";TriggerPosition: " + this.triggerPosition);
                bw.newLine();
            }
            int i = 0;
            while (i < this.values.length) {
                String hexVal = Integer.toHexString(this.values[i]);
                bw.write(String.valueOf("00000000".substring(hexVal.length())) + hexVal);
                bw.newLine();
                ++i;
            }
            bw.close();
        }
        catch (Exception E) {
            E.printStackTrace(System.out);
        }
    }

    public boolean hasTimingData() {
        return this.rate != -1;
    }

    public boolean hasTriggerData() {
        return this.triggerPosition != -1;
    }
}

